/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.SelectorFunctionKeysTest;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeExtractionTest;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExpressionKeysTest {
    ExpressionKeysTest() {
    }

    @Test
    void testBasicType() {
        BasicTypeInfo longType = BasicTypeInfo.LONG_TYPE_INFO;
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", (TypeInformation)longType);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
    }

    @Test
    void testGenericNonKeyType() {
        GenericTypeInfo genericType = new GenericTypeInfo(GenericNonKeyType.class);
        Assertions.assertThatExceptionOfType(InvalidProgramException.class).isThrownBy(() -> ExpressionKeysTest.lambda$testGenericNonKeyType$0((TypeInformation)genericType));
    }

    @Test
    void testKeyGenericType() {
        GenericTypeInfo genericType = new GenericTypeInfo(GenericKeyType.class);
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", (TypeInformation)genericType);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
    }

    @Test
    void testTupleRangeCheck() throws IllegalArgumentException {
        Keys.rangeCheckFields((int[])new int[]{1, 2, 3, 4}, (int)4);
        Keys.rangeCheckFields((int[])new int[]{0}, (int)0);
        Assertions.assertThatThrownBy(() -> Keys.rangeCheckFields((int[])new int[]{5}, (int)0));
    }

    @Test
    void testStandardTupleKeys() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        for (int i = 1; i < 8; ++i) {
            int[] ints = new int[i];
            for (int j = 0; j < i; ++j) {
                ints[j] = j;
            }
            int[] inInts = Arrays.copyOf(ints, ints.length);
            Keys.ExpressionKeys ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)ints);
            Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).hasSameSizeAs((Object)ints);
            ArrayUtils.reverse((int[])ints);
            inInts = Arrays.copyOf(ints, ints.length);
            ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)ints);
            Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).hasSameSizeAs((Object)ints);
        }
    }

    @Test
    void testInvalidTuple() {
        String[][] tests;
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        for (String[] test : tests = new String[][]{{"f0.f1"}, {"f11"}, {"f-35"}, {"f0.f33"}, {"f1.f33"}}) {
            Assertions.assertThatThrownBy(() -> new Keys.ExpressionKeys(test, (TypeInformation)typeInfo));
        }
    }

    @Test
    void testTupleNonKeyField() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.getForClass(GenericNonKeyType.class)});
        Assertions.assertThatExceptionOfType(InvalidProgramException.class).isThrownBy(() -> ExpressionKeysTest.lambda$testTupleNonKeyField$3((TypeInformation)ti));
    }

    @Test
    void testTupleKeyExpansion() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys fpk = new Keys.ExpressionKeys(0, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
        fpk = new Keys.ExpressionKeys(1, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2, 3});
        fpk = new Keys.ExpressionKeys(2, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{4});
        fpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        fpk = new Keys.ExpressionKeys(null, (TypeInformation)typeInfo, true);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        fpk = new Keys.ExpressionKeys("*", (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        fpk = new Keys.ExpressionKeys("_", (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        fpk = new Keys.ExpressionKeys("f2", (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{4});
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f1.f2", "f2"}, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f2"}, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 4});
        fpk = new Keys.ExpressionKeys(new String[]{"f2", "f0"}, (TypeInformation)typeInfo);
        Assertions.assertThat((int[])fpk.computeLogicalKeyPositions()).containsExactly(new int[]{4, 0});
        TupleTypeInfo complexTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys complexFpk = new Keys.ExpressionKeys(0, (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
        complexFpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4, 5, 6});
        complexFpk = new Keys.ExpressionKeys("*", (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4, 5, 6});
        complexFpk = new Keys.ExpressionKeys("_", (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4, 5, 6});
        complexFpk = new Keys.ExpressionKeys("f1.f0.*", (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2, 3});
        complexFpk = new Keys.ExpressionKeys("f1.f0", (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2, 3});
        complexFpk = new Keys.ExpressionKeys("f2", (TypeInformation)complexTypeInfo);
        Assertions.assertThat((int[])complexFpk.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{6});
    }

    @Test
    void testPojoKeys() {
        TypeInformation ti = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4});
        ek = new Keys.ExpressionKeys("p1.*", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2});
        ek = new Keys.ExpressionKeys("p2.*", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{3, 4});
        ek = new Keys.ExpressionKeys("p1", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2});
        ek = new Keys.ExpressionKeys("p2", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{3, 4});
        ek = new Keys.ExpressionKeys("i0", ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
    }

    @Test
    void testTupleWithNestedPojo() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(0, (TypeInformation)ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).isEqualTo((Object)new int[]{0});
        ek = new Keys.ExpressionKeys(1, (TypeInformation)ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{1, 2});
        ek = new Keys.ExpressionKeys(2, (TypeInformation)ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{3, 4, 5, 6, 7});
        ek = new Keys.ExpressionKeys(new int[0], (TypeInformation)ti, true);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        ek = new Keys.ExpressionKeys("*", (TypeInformation)ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        ek = new Keys.ExpressionKeys("f2.p1.*", (TypeInformation)ti);
        Assertions.assertThat((int[])ek.computeLogicalKeyPositions()).containsExactly(new int[]{4, 5});
    }

    @Test
    void testOriginalTypes() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(0, (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
        ek = new Keys.ExpressionKeys(1, (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)});
        ek = new Keys.ExpressionKeys(2, (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        ek = new Keys.ExpressionKeys(new int[0], (TypeInformation)ti, true);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        ek = new Keys.ExpressionKeys("*", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).isEqualTo((Object)new TypeInformation[]{ti});
        ek = new Keys.ExpressionKeys("f1", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)});
        ek = new Keys.ExpressionKeys("f1.*", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)});
        ek = new Keys.ExpressionKeys("f2.*", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        ek = new Keys.ExpressionKeys("f2.p2", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)});
        ek = new Keys.ExpressionKeys("f2.p2.*", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)});
        ek = new Keys.ExpressionKeys("f2.p2._", (TypeInformation)ti);
        Assertions.assertThat((Object[])ek.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)});
    }

    @Test
    void testNonKeyPojoField() {
        TypeInformation ti = TypeExtractor.getForClass(PojoWithNonKeyField.class);
        Assertions.assertThatThrownBy(() -> new Keys.ExpressionKeys("b", ti)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testInvalidPojo() {
        String[][] tests;
        TypeInformation ti = TypeExtractor.getForClass(PojoTypeExtractionTest.ComplexNestedClass.class);
        for (String[] test : tests = new String[][]{{"nonexistent"}, {"date.abc"}}) {
            Assertions.assertThatThrownBy(() -> new Keys.ExpressionKeys(test, ti));
        }
    }

    @Test
    void testAreCompatible1() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys("b", t1);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
        Assertions.assertThat((boolean)ek2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible2() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
        Assertions.assertThat((boolean)ek2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible3() throws Keys.IncompatibleKeysException {
        BasicTypeInfo t1 = BasicTypeInfo.STRING_TYPE_INFO;
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("*", (TypeInformation)t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
        Assertions.assertThat((boolean)ek2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible4() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"p1", "i0"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(new int[]{0, 0, 2}, (TypeInformation)t2);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
        Assertions.assertThat((boolean)ek2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible5() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"p1.b", "p2.a2"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys("*", (TypeInformation)t2);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
        Assertions.assertThat((boolean)ek2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible6() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(1, (TypeInformation)t2);
        Assertions.assertThatExceptionOfType(Keys.IncompatibleKeysException.class).isThrownBy(() -> ek1.areCompatible((Keys)ek2));
    }

    @Test
    void testAreCompatible7() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"a", "b"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        Assertions.assertThatExceptionOfType(Keys.IncompatibleKeysException.class).isThrownBy(() -> ek1.areCompatible((Keys)ek2));
    }

    @Test
    void testAreCompatible8() throws Keys.IncompatibleKeysException {
        BasicTypeInfo t1 = BasicTypeInfo.STRING_TYPE_INFO;
        TypeInformation t2 = TypeExtractor.getForClass(Pojo2.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("*", (TypeInformation)t1);
        Keys.SelectorFunctionKeys ek2 = new Keys.SelectorFunctionKeys((KeySelector)new SelectorFunctionKeysTest.KeySelector1(), t2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
    }

    @Test
    void testAreCompatible9() throws Keys.IncompatibleKeysException {
        TupleTypeInfo t1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        TypeInformation t2 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new int[]{2, 0}, (TypeInformation)t1);
        Keys.SelectorFunctionKeys ek2 = new Keys.SelectorFunctionKeys((KeySelector)new SelectorFunctionKeysTest.KeySelector3(), t2, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assertions.assertThat((boolean)ek1.areCompatible((Keys)ek2)).isTrue();
    }

    private static /* synthetic */ void lambda$testTupleNonKeyField$3(TypeInformation ti) throws Throwable {
        new Keys.ExpressionKeys(2, ti);
    }

    private static /* synthetic */ void lambda$testGenericNonKeyType$0(TypeInformation genericType) throws Throwable {
        new Keys.ExpressionKeys("*", genericType);
    }

    public static class GenericKeyType
    implements Comparable<GenericNonKeyType> {
        private String a;
        private String b;

        @Override
        public int compareTo(GenericNonKeyType o) {
            return 0;
        }
    }

    public static class GenericNonKeyType {
        private String a;
        private String b;
    }

    public static class PojoWithNonKeyField {
        public String a;
        public GenericNonKeyType b;
    }

    public static class PojoWithMultiplePojos {
        public Pojo1 p1;
        public Pojo2 p2;
        public Integer i0;
    }

    public static class Pojo2 {
        public String a2;
        public String b2;
    }

    public static class Pojo1 {
        public String a;
        public String b;
    }
}

