/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DualInputSemanticPropertiesTest {
    DualInputSemanticPropertiesTest() {
    }

    @Test
    void testGetTargetFields() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 1);
        sp.addForwardedField(0, 1, 4);
        sp.addForwardedField(0, 2, 3);
        sp.addForwardedField(0, 3, 2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 3)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 4)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 4)).isEmpty();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 1, 1);
        sp.addForwardedField(0, 1, 2);
        sp.addForwardedField(0, 1, 3);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).hasSize(3);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).isEmpty();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        sp.addForwardedField(1, 2, 3);
        sp.addForwardedField(1, 3, 2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 0)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 1)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 2)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 3)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 4)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 4)).isEmpty();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 0);
        sp.addForwardedField(1, 0, 4);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 1, 3);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 0)).hasSize(2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 1)).hasSize(3);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(3))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 2)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 2)).isEmpty();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 2, 6);
        sp.addForwardedField(0, 7, 8);
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 2)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 7)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 0)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 1)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(6))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 7).contains(Integer.valueOf(8))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 4)).isNotNull();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 4)).isEmpty();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 3, 8);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 4, 8);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 0)).hasSize(2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(0, 3)).hasSize(1);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 1)).hasSize(2);
        Assertions.assertThat((Iterable)sp.getForwardingTargetFields(1, 4)).hasSize(1);
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(8))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(8))).isTrue();
    }

    @Test
    void testGetSourceField() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 1);
        sp.addForwardedField(0, 1, 4);
        sp.addForwardedField(0, 2, 3);
        sp.addForwardedField(0, 3, 2);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 1)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 4)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 3)).isEqualTo(2);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 2)).isEqualTo(3);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 0)).isNegative();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 5)).isNegative();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(0, 0, 0);
        sp.addForwardedField(0, 0, 4);
        sp.addForwardedField(0, 1, 1);
        sp.addForwardedField(0, 1, 2);
        sp.addForwardedField(0, 1, 3);
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 0)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 4)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 1)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 2)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 3)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(0, 5)).isNegative();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 1);
        sp.addForwardedField(1, 1, 4);
        sp.addForwardedField(1, 2, 3);
        sp.addForwardedField(1, 3, 2);
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 1)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 4)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 3)).isEqualTo(2);
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 2)).isEqualTo(3);
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 0)).isNegative();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 5)).isNegative();
        sp = new DualInputSemanticProperties();
        sp.addForwardedField(1, 0, 0);
        sp.addForwardedField(1, 0, 4);
        sp.addForwardedField(1, 1, 1);
        sp.addForwardedField(1, 1, 2);
        sp.addForwardedField(1, 1, 3);
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 0)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 4)).isZero();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 1)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 2)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 3)).isOne();
        Assertions.assertThat((int)sp.getForwardingSourceField(1, 5)).isNegative();
    }

    @Test
    void testGetReadSet() {
        DualInputSemanticProperties sp = new DualInputSemanticProperties();
        sp.addReadFields(0, new FieldSet(new int[]{0, 1}));
        Assertions.assertThat((Iterable)sp.getReadFields(0)).hasSize(2);
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(1))).isTrue();
        sp.addReadFields(0, new FieldSet(Integer.valueOf(3)));
        Assertions.assertThat((Iterable)sp.getReadFields(0)).hasSize(3);
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(0).contains(Integer.valueOf(3))).isTrue();
        sp = new DualInputSemanticProperties();
        sp.addReadFields(1, new FieldSet(new int[]{0, 1}));
        Assertions.assertThat((Iterable)sp.getReadFields(1)).hasSize(2);
        Assertions.assertThat((boolean)sp.getReadFields(1).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(1).contains(Integer.valueOf(1))).isTrue();
        sp.addReadFields(1, new FieldSet(Integer.valueOf(3)));
        Assertions.assertThat((Iterable)sp.getReadFields(1)).hasSize(3);
        Assertions.assertThat((boolean)sp.getReadFields(1).contains(Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(1).contains(Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)sp.getReadFields(1).contains(Integer.valueOf(3))).isTrue();
    }

    @Test
    void testAddForwardedFieldsTargetTwice1() {
        Assertions.assertThatThrownBy(() -> {
            DualInputSemanticProperties sp = new DualInputSemanticProperties();
            sp.addForwardedField(0, 0, 2);
            sp.addForwardedField(0, 1, 2);
        }).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testAddForwardedFieldsTargetTwice2() {
        Assertions.assertThatThrownBy(() -> {
            DualInputSemanticProperties sp = new DualInputSemanticProperties();
            sp.addForwardedField(1, 0, 2);
            sp.addForwardedField(1, 1, 2);
        }).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }
}

