/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.IntValue;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class EnumerateNestedFilesTest {
    @TempDir
    private static java.nio.file.Path tempDir;
    protected Configuration config;
    private DummyFileInputFormat format;

    EnumerateNestedFilesTest() {
    }

    @BeforeEach
    void setup() {
        this.config = new Configuration();
        this.format = new DummyFileInputFormat();
    }

    @AfterEach
    void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
    }

    @Test
    void testNoNestedDirectoryTrue() throws IOException {
        String filePath = TestFileUtils.createTempFile("foo");
        this.format.setFilePath(new Path(filePath));
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)"recursive.file.enumeration"), (Object)true);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(1);
    }

    @Test
    void testOneNestedDirectoryTrue() throws IOException {
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        File insideNestedDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir});
        File nestedDir = insideNestedDir.getParentFile();
        TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(3);
    }

    @Test
    void testOneNestedDirectoryFalse() throws IOException {
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        File insideNestedDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir});
        File nestedDir = insideNestedDir.getParentFile();
        TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)"recursive.file.enumeration"), (Object)false);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(1);
    }

    @Test
    void testTwoNestedDirectoriesTrue() throws IOException {
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        String thirdLevelDir = TestFileUtils.randomFileName();
        File nestedNestedDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir, thirdLevelDir});
        File insideNestedDir = nestedNestedDir.getParentFile();
        File nestedDir = insideNestedDir.getParentFile();
        TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
        TestFileUtils.createTempFileInDirectory(nestedNestedDir.getAbsolutePath(), "bravas");
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(4);
    }

    @Test
    void testOnlyLevel2NestedDirectories() throws IOException {
        String rootDir = TestFileUtils.randomFileName();
        String nestedDir = TestFileUtils.randomFileName();
        String firstNestedNestedDir = TestFileUtils.randomFileName();
        String secondNestedNestedDir = TestFileUtils.randomFileName();
        File testDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{rootDir});
        TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{rootDir, nestedDir});
        File nestedNestedDir1 = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{rootDir, nestedDir, firstNestedNestedDir});
        File nestedNestedDir2 = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{rootDir, nestedDir, secondNestedNestedDir});
        TestFileUtils.createTempFileInDirectory(nestedNestedDir1.getAbsolutePath(), "paella");
        TestFileUtils.createTempFileInDirectory(nestedNestedDir1.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(nestedNestedDir2.getAbsolutePath(), "fideua");
        TestFileUtils.createTempFileInDirectory(nestedNestedDir2.getAbsolutePath(), "bravas");
        this.format.setFilePath(new Path(testDir.getAbsolutePath()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(4);
    }

    @Test
    void testTwoNestedDirectoriesWithFilteredFilesTrue() throws IOException {
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        String thirdLevelDir = TestFileUtils.randomFileName();
        String secondLevelFilterDir = "_" + TestFileUtils.randomFileName();
        String thirdLevelFilterDir = "_" + TestFileUtils.randomFileName();
        File nestedNestedDirFiltered = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir, thirdLevelDir, thirdLevelFilterDir});
        File nestedNestedDir = nestedNestedDirFiltered.getParentFile();
        File insideNestedDir = nestedNestedDir.getParentFile();
        File nestedDir = insideNestedDir.getParentFile();
        File insideNestedDirFiltered = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelFilterDir});
        File filteredFile = new File(nestedDir, "_IWillBeFiltered");
        filteredFile.createNewFile();
        TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
        TestFileUtils.createTempFileInDirectory(nestedNestedDir.getAbsolutePath(), "bravas");
        TestFileUtils.createTempFileInDirectory(insideNestedDirFiltered.getAbsolutePath(), "kalamari");
        TestFileUtils.createTempFileInDirectory(insideNestedDirFiltered.getAbsolutePath(), "fideua");
        TestFileUtils.createTempFileInDirectory(nestedNestedDirFiltered.getAbsolutePath(), "bravas");
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        Object[] splits = this.format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(4);
    }

    @Test
    void testGetStatisticsOneFileInNestedDir() throws IOException {
        long SIZE = 512000L;
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        File insideNestedDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir});
        File nestedDir = insideNestedDir.getParentFile();
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 512000L);
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        FileInputFormat.FileBaseStatistics stats = this.format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(512000L);
    }

    @Test
    void testGetStatisticsMultipleNestedFiles() throws IOException, InterruptedException {
        long SIZE1 = 2077L;
        long SIZE2 = 31909L;
        long SIZE3 = 10L;
        long SIZE4 = 71L;
        long TOTAL = 34067L;
        String firstLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir = TestFileUtils.randomFileName();
        String secondLevelDir2 = TestFileUtils.randomFileName();
        File insideNestedDir = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir});
        File insideNestedDir2 = TempDirUtils.newFolder((java.nio.file.Path)tempDir, (String[])new String[]{firstLevelDir, secondLevelDir2});
        File nestedDir = insideNestedDir.getParentFile();
        TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), 2077L);
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 31909L);
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 10L);
        TestFileUtils.createTempFileInDirectory(insideNestedDir2.getAbsolutePath(), 71L);
        this.format.setFilePath(new Path(nestedDir.toURI().toString()));
        this.format.setNestedFileEnumeration(true);
        this.format.configure(this.config);
        FileInputFormat.FileBaseStatistics stats = this.format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(34067L);
        Thread.sleep(1000L);
        TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 42L);
        FileInputFormat.FileBaseStatistics stats2 = this.format.getStatistics((BaseStatistics)stats);
        Assertions.assertThat((Object)stats).isNotEqualTo((Object)stats2);
        ((AbstractLongAssert)Assertions.assertThat((long)stats2.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(34109L);
    }

    private class DummyFileInputFormat
    extends FileInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;

        private DummyFileInputFormat() {
        }

        public boolean reachedEnd() {
            return true;
        }

        public IntValue nextRecord(IntValue reuse) {
            return null;
        }
    }
}

