/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.util.UUID;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WatermarkOutputMultiplexerTest {
    WatermarkOutputMultiplexerTest() {
    }

    @Test
    void singleImmediateWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.emitWatermark(new Watermark(0L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(0L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void singleImmediateIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.markIdle();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isTrue();
    }

    @Test
    void singleImmediateWatermarkAfterIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.markIdle();
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isTrue();
        watermarkOutput.emitWatermark(new Watermark(0L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(0L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void multipleImmediateWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput3 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput3.markIdle();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(2L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void whenImmediateOutputBecomesIdleWatermarkAdvances() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(2L));
        watermarkOutput1.markIdle();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
    }

    @Test
    void combinedWatermarkDoesNotRegressWhenIdleOutputRegresses() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput1.markIdle();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
        watermarkOutput1.emitWatermark(new Watermark(3L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
    }

    @Test
    void noCombinedDeferredUpdateWhenWeHaveZeroOutputs() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void deferredOutputDoesNotImmediatelyAdvanceWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(0L));
        watermarkOutput2.emitWatermark(new Watermark(1L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(0L));
    }

    @Test
    void singleDeferredWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.emitWatermark(new Watermark(0L));
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(0L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void singleDeferredIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.markIdle();
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isTrue();
    }

    @Test
    void singleDeferredWatermarkAfterIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.markIdle();
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isTrue();
        watermarkOutput.emitWatermark(new Watermark(0L));
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(0L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void multipleDeferredWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput3 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput3.markIdle();
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(2L));
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    @Test
    void immediateUpdatesTakeDeferredUpdatesIntoAccount() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput immediateOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput deferredOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        deferredOutput.emitWatermark(new Watermark(5L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
        immediateOutput.emitWatermark(new Watermark(2L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(2L));
    }

    @Test
    void immediateUpdateOnSameOutputAsDeferredUpdateDoesNotRegress() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        String id = "test-id";
        multiplexer.registerNewOutput("test-id", watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput("test-id");
        WatermarkOutput deferredOutput = multiplexer.getDeferredOutput("test-id");
        deferredOutput.emitWatermark(new Watermark(5L));
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
        immediateOutput.emitWatermark(new Watermark(2L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)new Watermark(5L));
    }

    @Test
    void lowerImmediateUpdateOnSameOutputDoesNotEmitCombinedUpdate() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        String id = "1234-test";
        multiplexer.registerNewOutput("1234-test", watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput("1234-test");
        WatermarkOutput deferredOutput = multiplexer.getDeferredOutput("1234-test");
        deferredOutput.emitWatermark(new Watermark(5L));
        immediateOutput.emitWatermark(new Watermark(2L));
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isNull();
    }

    @Test
    void testRemoveUnblocksWatermarks() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = 156765L;
        long highTimestamp = 156775L;
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(156765L));
        multiplexer.unregisterOutput("lower");
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(156775L));
        Assertions.assertThat((long)underlyingWatermarkOutput.lastWatermark().getTimestamp()).isEqualTo(156775L);
    }

    @Test
    void testRemoveOfLowestDoesNotImmediatelyAdvanceWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = -4343L;
        long highTimestamp = -4333L;
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(-4343L));
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(-4333L));
        multiplexer.unregisterOutput("lower");
        Assertions.assertThat((long)underlyingWatermarkOutput.lastWatermark().getTimestamp()).isEqualTo(-4343L);
    }

    @Test
    void testRemoveOfHighestDoesNotRetractWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = 1L;
        long highTimestamp = 2L;
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(2L));
        multiplexer.unregisterOutput("higher");
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(1L));
        Assertions.assertThat((long)underlyingWatermarkOutput.lastWatermark().getTimestamp()).isEqualTo(2L);
    }

    @Test
    void testRemoveRegisteredReturnValue() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        multiplexer.registerNewOutput("does-exist", watermark -> {});
        boolean unregistered = multiplexer.unregisterOutput("does-exist");
        Assertions.assertThat((boolean)unregistered).isTrue();
    }

    @Test
    void testRemoveNotRegisteredReturnValue() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        boolean unregistered = multiplexer.unregisterOutput("does-not-exist");
        Assertions.assertThat((boolean)unregistered).isFalse();
    }

    @Test
    void testNotEmittingIdleAfterAllSplitsRemoved() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        Watermark emittedWatermark = new Watermark(1L);
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput(id);
        immediateOutput.emitWatermark(emittedWatermark);
        multiplexer.unregisterOutput(id);
        multiplexer.onPeriodicEmit();
        Assertions.assertThat((Object)underlyingWatermarkOutput.lastWatermark()).isEqualTo((Object)emittedWatermark);
        Assertions.assertThat((boolean)underlyingWatermarkOutput.isIdle()).isFalse();
    }

    private static WatermarkOutput createImmediateOutput(WatermarkOutputMultiplexer multiplexer) {
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        return multiplexer.getImmediateOutput(id);
    }

    private static WatermarkOutput createDeferredOutput(WatermarkOutputMultiplexer multiplexer) {
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        return multiplexer.getDeferredOutput(id);
    }

    private static TestingWatermarkOutput createTestingWatermarkOutput() {
        return new TestingWatermarkOutput();
    }
}

