/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleMinimum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DoubleMinimumTest {
    DoubleMinimumTest() {
    }

    @Test
    void testGet() {
        DoubleMinimum min = new DoubleMinimum();
        Assertions.assertThat((Double)min.getLocalValue()).isCloseTo(Double.POSITIVE_INFINITY, Assertions.within((Double)0.0));
    }

    @Test
    void testResetLocal() {
        DoubleMinimum min = new DoubleMinimum();
        double value = 13.57902468;
        min.add(value);
        Assertions.assertThat((Double)min.getLocalValue()).isCloseTo(value, Assertions.within((Double)0.0));
        min.resetLocal();
        Assertions.assertThat((Double)min.getLocalValue()).isCloseTo(Double.POSITIVE_INFINITY, Assertions.within((Double)0.0));
    }

    @Test
    void testAdd() {
        DoubleMinimum min = new DoubleMinimum();
        min.add(1234.5768);
        min.add(9876.5432);
        min.add(-987.6543);
        min.add(-123.4567);
        Assertions.assertThat((Double)min.getLocalValue()).isCloseTo(-987.6543, Assertions.within((Double)0.0));
    }

    @Test
    void testMerge() {
        DoubleMinimum min1 = new DoubleMinimum();
        min1.add(1234.5768);
        DoubleMinimum min2 = new DoubleMinimum();
        min2.add(5678.9012);
        min2.merge((Accumulator)min1);
        Assertions.assertThat((Double)min2.getLocalValue()).isCloseTo(1234.5768, Assertions.within((Double)0.0));
        min1.merge((Accumulator)min2);
        Assertions.assertThat((Double)min1.getLocalValue()).isCloseTo(1234.5768, Assertions.within((Double)0.0));
    }

    @Test
    void testClone() {
        DoubleMinimum min = new DoubleMinimum();
        double value = 3.14159265359;
        min.add(value);
        DoubleMinimum clone = min.clone();
        Assertions.assertThat((Double)clone.getLocalValue()).isCloseTo(value, Assertions.within((Double)0.0));
    }
}

