/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AverageAccumulator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AverageAccumulatorTest {
    AverageAccumulatorTest() {
    }

    @Test
    void testGet() {
        AverageAccumulator average = new AverageAccumulator();
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(0.0, Assertions.within((Double)0.0));
    }

    @Test
    void testAdd() {
        AverageAccumulator average = new AverageAccumulator();
        for (int i1 = 0; i1 < 10; ++i1) {
            average.add(i1);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        Integer i2 = 0;
        while (i2 < 10) {
            average.add(i2.intValue());
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        for (long i3 = 0L; i3 < 10L; ++i3) {
            average.add(i3);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        Long i4 = 0L;
        while (i4 < 10L) {
            average.add(i4.longValue());
            Long l = i4;
            Long l2 = i4 = Long.valueOf(i4 + 1L);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        for (double i5 = 0.0; i5 < 10.0; i5 += 1.0) {
            average.add(i5);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        Double i6 = 0.0;
        while (i6 < 10.0) {
            average.add(i6);
            Double d = i6;
            Double d2 = i6 = Double.valueOf(i6 + 1.0);
        }
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
        average.resetLocal();
        Assertions.assertThat((Double)average.getLocalValue()).isCloseTo(0.0, Assertions.within((Double)0.0));
    }

    @Test
    void testMergeSuccess() {
        AverageAccumulator avg1 = new AverageAccumulator();
        for (int i = 0; i < 5; ++i) {
            avg1.add(i);
        }
        AverageAccumulator avg2 = new AverageAccumulator();
        for (int i = 5; i < 10; ++i) {
            avg2.add(i);
        }
        avg1.merge((Accumulator)avg2);
        Assertions.assertThat((Double)avg1.getLocalValue()).isCloseTo(4.5, Assertions.within((Double)0.0));
    }

    @Test
    void testMergeFailed() {
        AverageAccumulator average = new AverageAccumulator();
        Accumulator averageNew = null;
        average.add(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> average.merge(averageNew)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("The merged accumulator must be AverageAccumulator.");
    }

    @Test
    void testClone() {
        AverageAccumulator average = new AverageAccumulator();
        average.add(1);
        AverageAccumulator averageNew = average.clone();
        Assertions.assertThat((Double)averageNew.getLocalValue()).isCloseTo(1.0, Assertions.within((Double)0.0));
    }
}

