/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.teststats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.Queries;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

@JsonTypeName(value="zscore2sample")
public class ZtestPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator successCount1;
    private final PostAggregator sample1Size;
    private final PostAggregator successCount2;
    private final PostAggregator sample2Size;

    @JsonCreator
    public ZtestPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="successCount1") PostAggregator successCount1, @JsonProperty(value="sample1Size") PostAggregator sample1Size, @JsonProperty(value="successCount2") PostAggregator successCount2, @JsonProperty(value="sample2Size") PostAggregator sample2Size) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null post-aggregator name");
        Preconditions.checkNotNull((Object)successCount1, (Object)"success count from sample 1 can not be null");
        Preconditions.checkNotNull((Object)sample1Size, (Object)"sample size of population 1 can not null");
        Preconditions.checkNotNull((Object)successCount2, (Object)"success count from sample 2 can not be null");
        Preconditions.checkNotNull((Object)sample2Size, (Object)"sample size of population 2 can not be null");
        this.name = name;
        this.successCount1 = successCount1;
        this.sample1Size = sample1Size;
        this.successCount2 = successCount2;
        this.sample2Size = sample2Size;
    }

    public Set<String> getDependentFields() {
        LinkedHashSet<String> dependentFields = new LinkedHashSet<String>();
        dependentFields.addAll(this.successCount1.getDependentFields());
        dependentFields.addAll(this.sample1Size.getDependentFields());
        dependentFields.addAll(this.successCount2.getDependentFields());
        dependentFields.addAll(this.sample2Size.getDependentFields());
        return dependentFields;
    }

    public Comparator getComparator() {
        return ArithmeticPostAggregator.DEFAULT_COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        Object sc1 = this.successCount1.compute(combinedAggregators);
        Object ss1 = this.sample1Size.compute(combinedAggregators);
        Object sc2 = this.successCount2.compute(combinedAggregators);
        Object ss2 = this.sample2Size.compute(combinedAggregators);
        if (!(sc1 instanceof Number && sc2 instanceof Number && ss1 instanceof Number && ss2 instanceof Number)) {
            return null;
        }
        return this.zScoreTwoSamples(((Number)sc1).doubleValue(), ((Number)ss1).doubleValue(), ((Number)sc2).doubleValue(), ((Number)ss2).doubleValue());
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return ValueType.DOUBLE;
    }

    public ZtestPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new ZtestPostAggregator(this.name, (PostAggregator)Iterables.getOnlyElement((Iterable)Queries.decoratePostAggregators(Collections.singletonList(this.successCount1), aggregators)), (PostAggregator)Iterables.getOnlyElement((Iterable)Queries.decoratePostAggregators(Collections.singletonList(this.sample1Size), aggregators)), (PostAggregator)Iterables.getOnlyElement((Iterable)Queries.decoratePostAggregators(Collections.singletonList(this.successCount2), aggregators)), (PostAggregator)Iterables.getOnlyElement((Iterable)Queries.decoratePostAggregators(Collections.singletonList(this.sample2Size), aggregators)));
    }

    private double zScoreTwoSamples(double s1count, double p1count, double s2count, double p2count) {
        Preconditions.checkState((s1count >= 0.0 ? 1 : 0) != 0, (Object)"success count can't be negative.");
        Preconditions.checkState((s2count >= 0.0 ? 1 : 0) != 0, (Object)"success count can't be negative.");
        Preconditions.checkState((p1count >= s1count ? 1 : 0) != 0, (Object)"sample size can't be smaller than the success count.");
        Preconditions.checkState((p2count >= s2count ? 1 : 0) != 0, (Object)"sample size can't be smaller than the success count.");
        try {
            double convertRate1 = s1count / p1count;
            double convertRate2 = s2count / p2count;
            return (convertRate1 - convertRate2) / Math.sqrt(convertRate1 * (1.0 - convertRate1) / p1count + convertRate2 * (1.0 - convertRate2) / p2count);
        }
        catch (IllegalArgumentException ex) {
            return 0.0;
        }
    }

    @JsonProperty
    public PostAggregator getSuccessCount1() {
        return this.successCount1;
    }

    @JsonProperty
    public PostAggregator getSample1Size() {
        return this.sample1Size;
    }

    @JsonProperty
    public PostAggregator getSuccessCount2() {
        return this.successCount2;
    }

    @JsonProperty
    public PostAggregator getSample2Size() {
        return this.sample2Size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZtestPostAggregator that = (ZtestPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.successCount1.equals(that.successCount1) && this.sample1Size.equals(that.sample1Size) && this.successCount2.equals(that.successCount2) && this.sample2Size.equals(that.sample2Size);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.successCount1.hashCode();
        result = 31 * result + this.sample1Size.hashCode();
        result = 31 * result + this.successCount2.hashCode();
        result = 31 * result + this.sample2Size.hashCode();
        return result;
    }

    public String toString() {
        return "ZtestPostAggregator{name='" + this.name + '\'' + ", successCount1='" + this.successCount1 + '\'' + ", sample1Size='" + this.sample1Size + '\'' + ", successCount2='" + this.successCount2 + '\'' + ", sample2size='" + this.sample2Size + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(21).appendCacheable((Cacheable)this.successCount1).appendCacheable((Cacheable)this.sample1Size).appendCacheable((Cacheable)this.successCount2).appendCacheable((Cacheable)this.sample2Size).build();
    }
}

