/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance.sql;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.variance.StandardDeviationPostAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class BaseVarianceSqlAggregator
implements SqlAggregator {
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String inputTypeName;
        DimensionSpec dimensionSpec;
        RexNode inputOperand = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0)));
        DruidExpression input = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)inputOperand);
        if (input == null) {
            return null;
        }
        RelDataType dataType = inputOperand.getType();
        ValueType inputType = Calcites.getValueTypeForRelDataType((RelDataType)dataType);
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        String aggName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        SqlAggFunction func = this.calciteFunction();
        StandardDeviationPostAggregator postAggregator = null;
        if (input.isSimpleExtraction()) {
            dimensionSpec = input.getSimpleExtraction().toDimensionSpec(null, inputType);
        } else {
            VirtualColumn virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, input, dataType);
            dimensionSpec = new DefaultDimensionSpec(virtualColumn.getOutputName(), null, inputType);
            virtualColumns.add(virtualColumn);
        }
        switch (inputType) {
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                inputTypeName = StringUtils.toLowerCase((String)inputType.name());
                break;
            }
            default: {
                throw new IAE("VarianceSqlAggregator[%s] has invalid inputType[%s]", new Object[]{func, inputType});
            }
        }
        String estimator = func == SqlStdOperatorTable.VAR_POP || func == SqlStdOperatorTable.STDDEV_POP ? "population" : "sample";
        VarianceAggregatorFactory aggregatorFactory = new VarianceAggregatorFactory(aggName, dimensionSpec.getDimension(), estimator, inputTypeName);
        if (func == SqlStdOperatorTable.STDDEV_POP || func == SqlStdOperatorTable.STDDEV_SAMP || func == SqlStdOperatorTable.STDDEV) {
            postAggregator = new StandardDeviationPostAggregator(name, aggregatorFactory.getName(), estimator);
        }
        return Aggregation.create(virtualColumns, (List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)postAggregator);
    }

    public static class StdDevSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.STDDEV;
        }
    }

    public static class StdDevSampSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.STDDEV_SAMP;
        }
    }

    public static class StdDevPopSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.STDDEV_POP;
        }
    }

    public static class VarianceSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.VARIANCE;
        }
    }

    public static class VarSampSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.VAR_SAMP;
        }
    }

    public static class VarPopSqlAggregator
    extends BaseVarianceSqlAggregator {
        public SqlAggFunction calciteFunction() {
            return SqlStdOperatorTable.VAR_POP;
        }
    }
}

