/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.query.aggregation.variance.VarianceBufferAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class VarianceObjectVectorAggregator
implements VectorAggregator {
    private final VectorObjectSelector selector;

    public VarianceObjectVectorAggregator(VectorObjectSelector selector) {
        this.selector = selector;
    }

    public void init(ByteBuffer buf, int position) {
        VarianceBufferAggregator.doInit(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        VarianceAggregatorCollector[] vector = (VarianceAggregatorCollector[])this.selector.getObjectVector();
        VarianceAggregatorCollector previous = VarianceBufferAggregator.getVarianceCollector(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            previous.fold(vector[i]);
        }
        VarianceBufferAggregator.writeNVariance(buf, position, previous.count, previous.sum, previous.nvariance);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        VarianceAggregatorCollector[] vector = (VarianceAggregatorCollector[])this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            int row = rows != null ? rows[i] : i;
            VarianceAggregatorCollector previous = VarianceBufferAggregator.getVarianceCollector(buf, position);
            previous.fold(vector[row]);
            VarianceBufferAggregator.writeNVariance(buf, position, previous.count, previous.sum, previous.nvariance);
        }
    }

    @Nullable
    public VarianceAggregatorCollector get(ByteBuffer buf, int position) {
        return VarianceBufferAggregator.getVarianceCollector(buf, position);
    }

    public void close() {
    }
}

