/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.orc.OrcStructConverter;
import org.apache.druid.data.input.orc.OrcStructJsonProvider;
import org.apache.druid.java.util.common.parsers.NotImplementedMappingProvider;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcList;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;

public class OrcStructFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<OrcStruct> {
    private final Configuration jsonPathConfiguration;
    private final JsonProvider orcJsonProvider;
    private final OrcStructConverter converter;

    OrcStructFlattenerMaker(boolean binaryAsString) {
        this.converter = new OrcStructConverter(binaryAsString);
        this.orcJsonProvider = new OrcStructJsonProvider(this.converter);
        this.jsonPathConfiguration = Configuration.builder().jsonProvider(this.orcJsonProvider).mappingProvider((MappingProvider)new NotImplementedMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    }

    public Iterable<String> discoverRootFields(OrcStruct obj) {
        List fields = obj.getSchema().getFieldNames();
        List children = obj.getSchema().getChildren();
        ArrayList<String> primitiveFields = new ArrayList<String>();
        for (int i = 0; i < fields.size(); ++i) {
            if (!((TypeDescription)children.get(i)).getCategory().isPrimitive() && (!((TypeDescription)children.get(i)).getCategory().equals((Object)TypeDescription.Category.LIST) || !((TypeDescription)((TypeDescription)children.get(i)).getChildren().get(0)).getCategory().isPrimitive())) continue;
            primitiveFields.add((String)fields.get(i));
        }
        return primitiveFields;
    }

    public Object getRootField(OrcStruct obj, String key) {
        return this.finalizeConversion(this.converter.convertRootField(obj, key));
    }

    public Function<OrcStruct, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return record -> {
            Object val = jsonPath.read(record, this.jsonPathConfiguration);
            return this.finalizeConversion(val);
        };
    }

    @Nullable
    public Function<OrcStruct, Object> makeJsonQueryExtractor(String expr) {
        throw new UnsupportedOperationException("ORC flattener does not support JQ");
    }

    public JsonProvider getJsonProvider() {
        return this.orcJsonProvider;
    }

    private Object finalizeConversion(Object o) {
        if (o instanceof OrcStruct || o instanceof OrcMap || o instanceof OrcList) {
            return null;
        }
        return o;
    }
}

