/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.orc.OrcParseSpec;
import org.apache.druid.data.input.orc.OrcStructFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.orc.mapred.OrcStruct;

public class OrcHadoopInputRowParser
implements InputRowParser<OrcStruct> {
    private final ParseSpec parseSpec;
    private final ObjectFlattener<OrcStruct> orcStructFlattener;
    private final MapInputRowParser parser;
    private final boolean binaryAsString;

    @JsonCreator
    public OrcHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="binaryAsString") @Nullable Boolean binaryAsString) {
        this.parseSpec = parseSpec;
        this.binaryAsString = binaryAsString == null ? false : binaryAsString;
        JSONPathSpec flattenSpec = parseSpec instanceof OrcParseSpec ? (JSONPathSpec)((OrcParseSpec)parseSpec).getFlattenSpec() : JSONPathSpec.DEFAULT;
        this.orcStructFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new OrcStructFlattenerMaker(this.binaryAsString));
        this.parser = new MapInputRowParser(parseSpec);
    }

    @NotNull
    public List<InputRow> parseBatch(OrcStruct input) {
        return this.parser.parseBatch(this.orcStructFlattener.flatten((Object)input));
    }

    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new OrcHadoopInputRowParser(parseSpec, this.binaryAsString);
    }
}

