/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KinesisSupervisorTuningConfig
extends KinesisIndexTaskTuningConfig
implements SeekableStreamSupervisorTuningConfig {
    private final Integer workerThreads;
    private final Integer chatThreads;
    private final Long chatRetries;
    private final Duration httpTimeout;
    private final Duration shutdownTimeout;
    private final Duration repartitionTransitionDuration;
    private final Duration offsetFetchPeriod;

    public static KinesisSupervisorTuningConfig defaultConfig() {
        return new KinesisSupervisorTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public KinesisSupervisorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="skipSequenceNumberAvailabilityCheck") Boolean skipSequenceNumberAvailabilityCheck, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="workerThreads") Integer workerThreads, @JsonProperty(value="chatThreads") Integer chatThreads, @JsonProperty(value="chatRetries") Long chatRetries, @JsonProperty(value="httpTimeout") Period httpTimeout, @JsonProperty(value="shutdownTimeout") Period shutdownTimeout, @JsonProperty(value="recordBufferSize") Integer recordBufferSize, @JsonProperty(value="recordBufferOfferTimeout") Integer recordBufferOfferTimeout, @JsonProperty(value="recordBufferFullWait") Integer recordBufferFullWait, @JsonProperty(value="fetchSequenceNumberTimeout") Integer fetchSequenceNumberTimeout, @JsonProperty(value="fetchThreads") Integer fetchThreads, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxRecordsPerPoll") @Nullable Integer maxRecordsPerPoll, @JsonProperty(value="intermediateHandoffPeriod") Period intermediateHandoffPeriod, @JsonProperty(value="repartitionTransitionDuration") Period repartitionTransitionDuration, @JsonProperty(value="offsetFetchPeriod") Period offsetFetchPeriod) {
        super(maxRowsInMemory, maxBytesInMemory, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, buildV9Directly, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, skipSequenceNumberAvailabilityCheck, recordBufferSize, recordBufferOfferTimeout, recordBufferFullWait, fetchSequenceNumberTimeout, fetchThreads, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxRecordsPerPoll, intermediateHandoffPeriod);
        this.workerThreads = workerThreads;
        this.chatThreads = chatThreads;
        this.chatRetries = chatRetries != null ? chatRetries : 8L;
        this.httpTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)httpTimeout, (String)"PT10S");
        this.shutdownTimeout = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)shutdownTimeout, (String)"PT80S");
        this.repartitionTransitionDuration = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)repartitionTransitionDuration, (String)"PT2M");
        this.offsetFetchPeriod = SeekableStreamSupervisorTuningConfig.defaultDuration((Period)offsetFetchPeriod, (String)"PT30S");
    }

    @JsonProperty
    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    @JsonProperty
    public Integer getChatThreads() {
        return this.chatThreads;
    }

    @JsonProperty
    public Long getChatRetries() {
        return this.chatRetries;
    }

    @JsonProperty
    public Duration getHttpTimeout() {
        return this.httpTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Duration getRepartitionTransitionDuration() {
        return this.repartitionTransitionDuration;
    }

    @JsonProperty
    public Duration getOffsetFetchPeriod() {
        return this.offsetFetchPeriod;
    }

    @Override
    public String toString() {
        return "KinesisSupervisorTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxBytesInMemory=" + this.getMaxBytesInMemory() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", maxTotalRows=" + this.getMaxTotalRows() + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", skipSequenceNumberAvailabilityCheck=" + this.isSkipSequenceNumberAvailabilityCheck() + ", workerThreads=" + this.workerThreads + ", chatThreads=" + this.chatThreads + ", chatRetries=" + this.chatRetries + ", httpTimeout=" + this.httpTimeout + ", shutdownTimeout=" + this.shutdownTimeout + ", recordBufferSize=" + this.getRecordBufferSize() + ", recordBufferOfferTimeout=" + this.getRecordBufferOfferTimeout() + ", recordBufferFullWait=" + this.getRecordBufferFullWait() + ", fetchSequenceNumberTimeout=" + this.getFetchSequenceNumberTimeout() + ", fetchThreads=" + this.getFetchThreads() + ", segmentWriteOutMediumFactory=" + this.getSegmentWriteOutMediumFactory() + ", logParseExceptions=" + this.isLogParseExceptions() + ", maxParseExceptions=" + this.getMaxParseExceptions() + ", maxSavedParseExceptions=" + this.getMaxSavedParseExceptions() + ", maxRecordsPerPoll=" + this.getMaxRecordsPerPoll() + ", intermediateHandoffPeriod=" + this.getIntermediateHandoffPeriod() + ", repartitionTransitionDuration=" + this.getRepartitionTransitionDuration() + '}';
    }

    public KinesisIndexTaskTuningConfig convertToTaskTuningConfig() {
        return new KinesisIndexTaskTuningConfig(this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.getMaxRowsPerSegment(), this.getMaxTotalRows(), this.getIntermediatePersistPeriod(), this.getBasePersistDirectory(), this.getMaxPendingPersists(), this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), true, this.isReportParseExceptions(), this.getHandoffConditionTimeout(), this.isResetOffsetAutomatically(), this.isSkipSequenceNumberAvailabilityCheck(), this.getRecordBufferSize(), this.getRecordBufferOfferTimeout(), this.getRecordBufferFullWait(), this.getFetchSequenceNumberTimeout(), this.getFetchThreads(), this.getSegmentWriteOutMediumFactory(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxRecordsPerPoll(), this.getIntermediateHandoffPeriod());
    }
}

