/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import java.math.BigInteger;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;

public class KinesisSequenceNumber
extends OrderedSequenceNumber<String> {
    public static final String END_OF_SHARD_MARKER = "EOS";
    public static final String NO_END_SEQUENCE_NUMBER = "NO_END_SEQUENCE_NUMBER";
    public static final String EXPIRED_MARKER = "EXPIRED";
    private final boolean isMaxSequenceNumber;
    private final BigInteger intSequence;

    private KinesisSequenceNumber(String sequenceNumber, boolean isExclusive) {
        super((Object)sequenceNumber, isExclusive);
        if (END_OF_SHARD_MARKER.equals(sequenceNumber) || NO_END_SEQUENCE_NUMBER.equals(sequenceNumber) || EXPIRED_MARKER.equals(sequenceNumber)) {
            this.isMaxSequenceNumber = true;
            this.intSequence = null;
        } else {
            this.isMaxSequenceNumber = false;
            this.intSequence = new BigInteger(sequenceNumber);
        }
    }

    public static KinesisSequenceNumber of(String sequenceNumber) {
        return new KinesisSequenceNumber(sequenceNumber, false);
    }

    public static KinesisSequenceNumber of(String sequenceNumber, boolean isExclusive) {
        return new KinesisSequenceNumber(sequenceNumber, isExclusive);
    }

    public static boolean isValidAWSKinesisSequence(String sequenceNumber) {
        return !END_OF_SHARD_MARKER.equals(sequenceNumber) && !NO_END_SEQUENCE_NUMBER.equals(sequenceNumber) && !EXPIRED_MARKER.equals(sequenceNumber);
    }

    public int compareTo(OrderedSequenceNumber<String> o) {
        KinesisSequenceNumber num = (KinesisSequenceNumber)o;
        if (this.isMaxSequenceNumber && num.isMaxSequenceNumber) {
            return 0;
        }
        if (this.isMaxSequenceNumber) {
            return 1;
        }
        if (num.isMaxSequenceNumber) {
            return -1;
        }
        return this.intSequence.compareTo(new BigInteger((String)o.get()));
    }
}

