/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskIOConfig;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskRunner;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskTuningConfig;
import org.apache.druid.indexing.kinesis.KinesisRecordSupplier;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.segment.indexing.DataSchema;

public class KinesisIndexTask
extends SeekableStreamIndexTask<String, String> {
    private static final String TYPE = "index_kinesis";
    private final AWSCredentialsConfig awsCredentialsConfig;

    @JsonCreator
    public KinesisIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KinesisIndexTaskTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KinesisIndexTaskIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject @Named(value="kinesis") AWSCredentialsConfig awsCredentialsConfig) {
        super(KinesisIndexTask.getOrMakeId((String)id, (String)dataSchema.getDataSource(), (String)TYPE), taskResource, dataSchema, (SeekableStreamIndexTaskTuningConfig)tuningConfig, (SeekableStreamIndexTaskIOConfig)ioConfig, context, KinesisIndexTask.getFormattedGroupId((String)dataSchema.getDataSource(), (String)TYPE));
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    protected SeekableStreamIndexTaskRunner<String, String> createTaskRunner() {
        return new KinesisIndexTaskRunner(this, (InputRowParser<ByteBuffer>)this.dataSchema.getParser(), this.authorizerMapper, this.lockGranularityToUse);
    }

    protected KinesisRecordSupplier newTaskRecordSupplier() throws RuntimeException {
        KinesisIndexTaskIOConfig ioConfig = (KinesisIndexTaskIOConfig)this.ioConfig;
        KinesisIndexTaskTuningConfig tuningConfig = (KinesisIndexTaskTuningConfig)this.tuningConfig;
        int fetchThreads = tuningConfig.getFetchThreads() != null ? tuningConfig.getFetchThreads() : Runtime.getRuntime().availableProcessors() * 2;
        Preconditions.checkArgument((fetchThreads > 0 ? 1 : 0) != 0, (Object)"Must have at least one background fetch thread for the record supplier");
        return new KinesisRecordSupplier(KinesisRecordSupplier.getAmazonKinesisClient(ioConfig.getEndpoint(), this.awsCredentialsConfig, ioConfig.getAwsAssumedRoleArn(), ioConfig.getAwsExternalId()), ioConfig.getRecordsPerFetch(), ioConfig.getFetchDelayMillis(), fetchThreads, ioConfig.isDeaggregate(), tuningConfig.getRecordBufferSize(), tuningConfig.getRecordBufferOfferTimeout(), tuningConfig.getRecordBufferFullWait(), tuningConfig.getFetchSequenceNumberTimeout(), tuningConfig.getMaxRecordsPerPoll(), false);
    }

    @JsonProperty(value="ioConfig")
    public KinesisIndexTaskIOConfig getIOConfig() {
        return (KinesisIndexTaskIOConfig)super.getIOConfig();
    }

    public String getType() {
        return TYPE;
    }

    public boolean supportsQueries() {
        return true;
    }

    @VisibleForTesting
    AWSCredentialsConfig getAwsCredentialsConfig() {
        return this.awsCredentialsConfig;
    }
}

