/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kafka.IncrementalPublishingKafkaIndexTaskRunner;
import org.apache.druid.indexing.kafka.KafkaConsumerConfigs;
import org.apache.druid.indexing.kafka.KafkaIndexTaskIOConfig;
import org.apache.druid.indexing.kafka.KafkaIndexTaskTuningConfig;
import org.apache.druid.indexing.kafka.KafkaRecordSupplier;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.utils.CircularBuffer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;

public class KafkaIndexTask
extends SeekableStreamIndexTask<Integer, Long> {
    private static final String TYPE = "index_kafka";
    private final KafkaIndexTaskIOConfig ioConfig;
    private final ObjectMapper configMapper;
    private long pollRetryMs = 30000L;

    @JsonCreator
    public KafkaIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaIndexTaskTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaIndexTaskIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject ObjectMapper configMapper, @JacksonInject AppenderatorsManager appenderatorsManager) {
        super(KafkaIndexTask.getOrMakeId((String)id, (String)dataSchema.getDataSource(), (String)TYPE), taskResource, dataSchema, (SeekableStreamIndexTaskTuningConfig)tuningConfig, (SeekableStreamIndexTaskIOConfig)ioConfig, context, chatHandlerProvider, authorizerMapper, rowIngestionMetersFactory, KafkaIndexTask.getFormattedGroupId((String)dataSchema.getDataSource(), (String)TYPE), appenderatorsManager);
        this.configMapper = configMapper;
        this.ioConfig = ioConfig;
        Preconditions.checkArgument((boolean)ioConfig.getStartSequenceNumbers().getExclusivePartitions().isEmpty(), (Object)"All startSequenceNumbers must be inclusive");
    }

    long getPollRetryMs() {
        return this.pollRetryMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    KafkaConsumer<byte[], byte[]> newConsumer() {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Map<String, Object> consumerConfigs = KafkaConsumerConfigs.getConsumerProperties();
            Properties props = new Properties();
            KafkaRecordSupplier.addConsumerPropertiesFromConfig(props, this.configMapper, this.ioConfig.getConsumerProperties());
            props.putAll(consumerConfigs);
            KafkaConsumer kafkaConsumer = new KafkaConsumer(props);
            return kafkaConsumer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    @Deprecated
    static void assignPartitions(KafkaConsumer consumer, String topic, Set<Integer> partitions) {
        consumer.assign(new ArrayList(partitions.stream().map(n -> new TopicPartition(topic, n.intValue())).collect(Collectors.toList())));
    }

    protected SeekableStreamIndexTaskRunner<Integer, Long> createTaskRunner() {
        return new IncrementalPublishingKafkaIndexTaskRunner(this, (InputRowParser<ByteBuffer>)this.dataSchema.getParser(), this.authorizerMapper, (Optional<ChatHandlerProvider>)this.chatHandlerProvider, (CircularBuffer<Throwable>)this.savedParseExceptions, this.rowIngestionMetersFactory, this.appenderatorsManager, this.lockGranularityToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KafkaRecordSupplier newTaskRecordSupplier() {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            HashMap<String, Object> props = new HashMap<String, Object>(((KafkaIndexTaskIOConfig)((SeekableStreamIndexTask)this).ioConfig).getConsumerProperties());
            props.put("auto.offset.reset", "none");
            KafkaRecordSupplier kafkaRecordSupplier = new KafkaRecordSupplier(props, this.configMapper);
            return kafkaRecordSupplier;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    @JsonProperty
    public KafkaIndexTaskTuningConfig getTuningConfig() {
        return (KafkaIndexTaskTuningConfig)super.getTuningConfig();
    }

    @VisibleForTesting
    void setPollRetryMs(long retryMs) {
        this.pollRetryMs = retryMs;
    }

    @JsonProperty(value="ioConfig")
    public KafkaIndexTaskIOConfig getIOConfig() {
        return (KafkaIndexTaskIOConfig)super.getIOConfig();
    }

    public String getType() {
        return TYPE;
    }
}

