/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchUnaryPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class ArrayOfDoublesSketchToEstimateAndBoundsPostAggregator
extends ArrayOfDoublesSketchUnaryPostAggregator {
    private final int numStdDevs;

    @JsonCreator
    public ArrayOfDoublesSketchToEstimateAndBoundsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="numStdDevs") @Nullable Integer numStdDevs) {
        super(name, field);
        this.numStdDevs = numStdDevs == null ? 1 : numStdDevs;
    }

    @JsonProperty
    public int getNumStdDevs() {
        return this.numStdDevs;
    }

    public double[] compute(Map<String, Object> combinedAggregators) {
        ArrayOfDoublesSketch sketch = (ArrayOfDoublesSketch)this.getField().compute(combinedAggregators);
        return new double[]{sketch.getEstimate(), sketch.getLowerBound(this.numStdDevs), sketch.getUpperBound(this.numStdDevs)};
    }

    public ValueType getType() {
        return ValueType.DOUBLE_ARRAY;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing arrays of estimates and error bounds is not supported", new Object[0]);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + '\'' + ", field=" + this.getField() + ", numStdDevs=" + this.numStdDevs + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ArrayOfDoublesSketchToEstimateAndBoundsPostAggregator)) {
            return false;
        }
        ArrayOfDoublesSketchToEstimateAndBoundsPostAggregator that = (ArrayOfDoublesSketchToEstimateAndBoundsPostAggregator)o;
        return this.numStdDevs == that.numStdDevs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numStdDevs);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(36).appendCacheable((Cacheable)this.getField()).appendInt(this.numStdDevs).build();
    }
}

