/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.ArrayOfDoublesUnion;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchBuildBufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class ArrayOfDoublesSketchMergeBufferAggregator
implements BufferAggregator {
    private static final int NUM_STRIPES = 64;
    private final BaseObjectColumnValueSelector<ArrayOfDoublesSketch> selector;
    private final int nominalEntries;
    private final int numberOfValues;
    private final int maxIntermediateSize;
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);

    public ArrayOfDoublesSketchMergeBufferAggregator(BaseObjectColumnValueSelector<ArrayOfDoublesSketch> selector, int nominalEntries, int numberOfValues, int maxIntermediateSize) {
        this.selector = selector;
        this.nominalEntries = nominalEntries;
        this.numberOfValues = numberOfValues;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.nominalEntries).setNumberOfValues(this.numberOfValues).buildUnion(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        ArrayOfDoublesSketch update = (ArrayOfDoublesSketch)this.selector.getObject();
        if (update == null) {
            return;
        }
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(ArrayOfDoublesSketchBuildBufferAggregator.lockIndex(position))).writeLock();
        lock.lock();
        try {
            ArrayOfDoublesUnion union = ArrayOfDoublesSketches.wrapUnion((WritableMemory)region);
            union.update(update);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(ArrayOfDoublesSketchBuildBufferAggregator.lockIndex(position))).readLock();
        lock.lock();
        try {
            ArrayOfDoublesUnion union = ArrayOfDoublesSketches.wrapUnion((WritableMemory)region);
            ArrayOfDoublesCompactSketch arrayOfDoublesCompactSketch = union.getResult();
            return arrayOfDoublesCompactSketch;
        }
        finally {
            lock.unlock();
        }
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

