/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class ArrayOfDoublesSketchBuildAggregator
implements Aggregator {
    private final DimensionSelector keySelector;
    private final BaseDoubleColumnValueSelector[] valueSelectors;
    @Nullable
    private double[] values;
    @Nullable
    private ArrayOfDoublesUpdatableSketch sketch;

    public ArrayOfDoublesSketchBuildAggregator(DimensionSelector keySelector, List<BaseDoubleColumnValueSelector> valueSelectors, int nominalEntries) {
        this.keySelector = keySelector;
        this.valueSelectors = valueSelectors.toArray(new BaseDoubleColumnValueSelector[0]);
        this.values = new double[valueSelectors.size()];
        this.sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(nominalEntries).setNumberOfValues(valueSelectors.size()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        IndexedInts keys = this.keySelector.getRow();
        for (int i = 0; i < this.valueSelectors.length; ++i) {
            if (this.valueSelectors[i].isNull()) {
                return;
            }
            this.values[i] = this.valueSelectors[i].getDouble();
        }
        ArrayOfDoublesSketchBuildAggregator arrayOfDoublesSketchBuildAggregator = this;
        synchronized (arrayOfDoublesSketchBuildAggregator) {
            int keysSize = keys.size();
            for (int i = 0; i < keysSize; ++i) {
                String key = this.keySelector.lookupName(keys.get(i));
                this.sketch.update(key, this.values);
            }
        }
    }

    public synchronized Object get() {
        return this.sketch.compact();
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.sketch = null;
        this.values = null;
    }
}

