/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class SketchToStringPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;

    @JsonCreator
    public SketchToStringPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field) {
        this.name = name;
        this.field = field;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public Comparator<String> getComparator() {
        return Comparator.nullsFirst(Comparator.naturalOrder());
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        SketchHolder holder = (SketchHolder)this.field.compute(combinedAggregators);
        return holder.getSketch().toString();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return ValueType.STRING;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(29).appendString(this.name).appendCacheable((Cacheable)this.field).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", field=" + this.field + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchToStringPostAggregator that = (SketchToStringPostAggregator)o;
        return this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field);
    }
}

