/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.query.aggregation.datasketches.theta.SketchBuildComplexMetricSerde;
import org.apache.druid.query.aggregation.datasketches.theta.SketchConstantPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolderJsonSerializer;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeComplexMetricSerde;
import org.apache.druid.query.aggregation.datasketches.theta.SketchSetPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchToStringPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchApproxCountDistinctSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchEstimateOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchEstimateWithErrorBoundsOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchObjectSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetIntersectOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetNotOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetUnionOperatorConversion;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.sql.guice.SqlBindings;

public class SketchModule
implements DruidModule {
    public static final String THETA_SKETCH = "thetaSketch";
    public static final String THETA_SKETCH_MERGE_AGG = "thetaSketchMerge";
    public static final String THETA_SKETCH_BUILD_AGG = "thetaSketchBuild";
    public static final String THETA_SKETCH_ESTIMATE_POST_AGG = "thetaSketchEstimate";
    public static final String THETA_SKETCH_SET_OP_POST_AGG = "thetaSketchSetOp";
    public static final String THETA_SKETCH_CONSTANT_POST_AGG = "thetaSketchConstant";
    public static final String THETA_SKETCH_TO_STRING_POST_AGG = "thetaSketchToString";

    public void configure(Binder binder) {
        SketchModule.registerSerde();
        SqlBindings.addAggregator((Binder)binder, ThetaSketchApproxCountDistinctSqlAggregator.class);
        SqlBindings.addAggregator((Binder)binder, ThetaSketchObjectSqlAggregator.class);
        SqlBindings.addOperatorConversion((Binder)binder, ThetaSketchEstimateOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, ThetaSketchEstimateWithErrorBoundsOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, ThetaSketchSetIntersectOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, ThetaSketchSetUnionOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, ThetaSketchSetNotOperatorConversion.class);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("ThetaSketchModule").registerSubtypes(new NamedType[]{new NamedType(SketchMergeAggregatorFactory.class, THETA_SKETCH), new NamedType(SketchEstimatePostAggregator.class, THETA_SKETCH_ESTIMATE_POST_AGG), new NamedType(SketchSetPostAggregator.class, THETA_SKETCH_SET_OP_POST_AGG), new NamedType(SketchConstantPostAggregator.class, THETA_SKETCH_CONSTANT_POST_AGG), new NamedType(SketchToStringPostAggregator.class, THETA_SKETCH_TO_STRING_POST_AGG)}).addSerializer(SketchHolder.class, (JsonSerializer)new SketchHolderJsonSerializer()));
    }

    @VisibleForTesting
    public static void registerSerde() {
        ComplexMetrics.registerSerde((String)THETA_SKETCH, (ComplexMetricSerde)new SketchMergeComplexMetricSerde());
        ComplexMetrics.registerSerde((String)THETA_SKETCH_MERGE_AGG, (ComplexMetricSerde)new SketchMergeComplexMetricSerde());
        ComplexMetrics.registerSerde((String)THETA_SKETCH_BUILD_AGG, (ComplexMetricSerde)new SketchBuildComplexMetricSerde());
    }
}

