/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class HllSketchUnionPostAggregator
implements PostAggregator {
    private final String name;
    private final List<PostAggregator> fields;
    private final int lgK;
    private final TgtHllType tgtHllType;

    @JsonCreator
    public HllSketchUnionPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fields") List<PostAggregator> fields, @JsonProperty(value="lgK") @Nullable Integer lgK, @JsonProperty(value="tgtHllType") @Nullable String tgtHllType) {
        this.name = name;
        this.fields = fields;
        this.lgK = lgK == null ? 12 : lgK;
        this.tgtHllType = tgtHllType == null ? HllSketchAggregatorFactory.DEFAULT_TGT_HLL_TYPE : TgtHllType.valueOf((String)tgtHllType);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return ValueType.COMPLEX;
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    @JsonProperty
    public int getLgK() {
        return this.lgK;
    }

    @JsonProperty
    public String getTgtHllType() {
        return this.tgtHllType.toString();
    }

    public Set<String> getDependentFields() {
        LinkedHashSet<String> dependentFields = new LinkedHashSet<String>();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    public Comparator<HllSketch> getComparator() {
        return HllSketchAggregatorFactory.COMPARATOR;
    }

    public HllSketch compute(Map<String, Object> combinedAggregators) {
        Union union = new Union(this.lgK);
        for (PostAggregator field : this.fields) {
            HllSketch sketch = (HllSketch)field.compute(combinedAggregators);
            union.update(sketch);
        }
        return union.getResult(this.tgtHllType);
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(48).appendString(this.name).appendCacheablesIgnoringOrder(this.fields).appendInt(this.lgK).appendInt(this.tgtHllType.ordinal()).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", fields=" + this.fields + ", lgK=" + this.lgK + ", tgtHllType=" + this.tgtHllType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HllSketchUnionPostAggregator that = (HllSketchUnionPostAggregator)o;
        return this.lgK == that.lgK && this.name.equals(that.name) && this.fields.equals(that.fields) && this.tgtHllType == that.tgtHllType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.lgK, this.tgtHllType);
    }
}

