/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchMergeBufferAggregator
implements BufferAggregator {
    private static final int NUM_STRIPES = 64;
    private final ColumnValueSelector<HllSketch> selector;
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final int size;
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);
    private final byte[] emptyUnion;

    public HllSketchMergeBufferAggregator(ColumnValueSelector<HllSketch> selector, int lgK, TgtHllType tgtHllType, int size) {
        this.selector = selector;
        this.lgK = lgK;
        this.tgtHllType = tgtHllType;
        this.size = size;
        this.emptyUnion = new byte[size];
        new Union(lgK, WritableMemory.wrap((byte[])this.emptyUnion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            buf.put(this.emptyUnion);
        }
        finally {
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        HllSketch sketch = (HllSketch)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.size);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(HllSketchBuildBufferAggregator.lockIndex(position))).writeLock();
        lock.lock();
        try {
            Union union = Union.writableWrap((WritableMemory)mem);
            union.update(sketch);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.size);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(HllSketchBuildBufferAggregator.lockIndex(position))).readLock();
        lock.lock();
        try {
            Union union = Union.writableWrap((WritableMemory)mem);
            HllSketch hllSketch = union.getResult(this.tgtHllType);
            return hllSketch;
        }
        finally {
            lock.unlock();
        }
    }

    public void close() {
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("lgK", (Object)this.lgK);
    }
}

