/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeBufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchMergeAggregatorFactory
extends HllSketchAggregatorFactory {
    @JsonCreator
    public HllSketchMergeAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="lgK") @Nullable Integer lgK, @JsonProperty(value="tgtHllType") @Nullable String tgtHllType, @JsonProperty(value="round") boolean round) {
        super(name, fieldName, lgK, tgtHllType, round);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof HllSketchMergeAggregatorFactory) {
            HllSketchMergeAggregatorFactory castedOther = (HllSketchMergeAggregatorFactory)other;
            return new HllSketchMergeAggregatorFactory(this.getName(), this.getName(), Math.max(this.getLgK(), castedOther.getLgK()), this.getTgtHllType().compareTo(castedOther.getTgtHllType()) < 0 ? castedOther.getTgtHllType() : this.getTgtHllType(), this.isRound() || castedOther.isRound());
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public String getComplexTypeName() {
        return "HLLSketchMerge";
    }

    @Override
    protected byte getCacheTypeId() {
        return 47;
    }

    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        return new HllSketchMergeAggregator((ColumnValueSelector<HllSketch>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        return new HllSketchMergeBufferAggregator((ColumnValueSelector<HllSketch>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getMaxIntermediateSize());
    }

    public int getMaxIntermediateSize() {
        return Union.getMaxSerializationBytes((int)this.getLgK());
    }
}

