/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.google.common.util.concurrent.Striped;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchBuildBufferAggregator
implements BufferAggregator {
    private static final int NUM_STRIPES = 64;
    private final ColumnValueSelector<Object> selector;
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final int size;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<HllSketch>> sketchCache = new IdentityHashMap();
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);
    private final byte[] emptySketch;

    public HllSketchBuildBufferAggregator(ColumnValueSelector<Object> selector, int lgK, TgtHllType tgtHllType, int size) {
        this.selector = selector;
        this.lgK = lgK;
        this.tgtHllType = tgtHllType;
        this.size = size;
        this.emptySketch = new byte[size];
        new HllSketch(lgK, tgtHllType, WritableMemory.wrap((byte[])this.emptySketch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            buf.put(this.emptySketch);
        }
        finally {
            buf.position(oldPosition);
        }
        WritableMemory mem = this.getMemory(buf).writableRegion((long)position, (long)this.size);
        this.putSketchIntoCache(buf, position, HllSketch.writableWrap((WritableMemory)mem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        Object value = this.selector.getObject();
        if (value == null) {
            return;
        }
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(HllSketchBuildBufferAggregator.lockIndex(position))).writeLock();
        lock.lock();
        try {
            HllSketch sketch = (HllSketch)this.sketchCache.get(buf).get(position);
            HllSketchBuildAggregator.updateSketch(sketch, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(ByteBuffer buf, int position) {
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(HllSketchBuildBufferAggregator.lockIndex(position))).readLock();
        lock.lock();
        try {
            HllSketch hllSketch = ((HllSketch)this.sketchCache.get(buf).get(position)).copy();
            return hllSketch;
        }
        finally {
            lock.unlock();
        }
    }

    public void close() {
        this.memCache.clear();
        this.sketchCache.clear();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private WritableMemory getMemory(ByteBuffer buf) {
        return this.memCache.computeIfAbsent(buf, b -> WritableMemory.wrap((ByteBuffer)b, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        WritableMemory oldMem;
        HllSketch sketch = (HllSketch)this.sketchCache.get(oldBuf).get(oldPosition);
        if (sketch.isSameResource((Memory)(oldMem = this.getMemory(oldBuf).writableRegion((long)oldPosition, (long)this.size)))) {
            WritableMemory newMem = this.getMemory(newBuf).writableRegion((long)newPosition, (long)this.size);
            sketch = HllSketch.writableWrap((WritableMemory)newMem);
        }
        this.putSketchIntoCache(newBuf, newPosition, sketch);
    }

    private void putSketchIntoCache(ByteBuffer buf, int position, HllSketch sketch) {
        Int2ObjectMap map = this.sketchCache.computeIfAbsent(buf, b -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)sketch);
    }

    static int lockIndex(int position) {
        return HllSketchBuildBufferAggregator.smear(position) % 64;
    }

    private static int smear(int hashCode) {
        hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
        return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("lgK", (Object)this.lgK);
    }
}

