/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.java.util.common.StringUtils;

class GenerateTestData {
    GenerateTestData() {
    }

    public static void main(String[] args) throws Exception {
        GenerateTestData.generateSketches();
        GenerateTestData.generateBucketTestData();
    }

    private static void generateSketches() throws Exception {
        Path path = FileSystems.getDefault().getPath("array_of_doubles_sketch_data.tsv", new String[0]);
        try (BufferedWriter out = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            int key = 0;
            for (int i = 0; i < 20; ++i) {
                ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(1024).build();
                sketch.update((long)key++, new double[]{1.0});
                sketch.update((long)key++, new double[]{1.0});
                out.write("2015010101");
                out.write(9);
                out.write("product_" + (((Random)rand).nextInt(10) + 1));
                out.write(9);
                out.write(StringUtils.encodeBase64String((byte[])sketch.compact().toByteArray()));
                out.newLine();
            }
        }
    }

    private static void generateBucketTestData() throws Exception {
        double meanTest = 10.0;
        double meanControl = 10.2;
        Path path = FileSystems.getDefault().getPath("bucket_test_data.tsv", new String[0]);
        try (BufferedWriter out = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < 1000; ++i) {
                GenerateTestData.writeBucketTestRecord(out, "test", i, rand.nextGaussian() + meanTest);
                GenerateTestData.writeBucketTestRecord(out, "control", i, rand.nextGaussian() + meanControl);
            }
        }
    }

    private static void writeBucketTestRecord(BufferedWriter out, String label, int id, double parameter) throws Exception {
        out.write("20170101");
        out.write("\t");
        out.write(label);
        out.write("\t");
        out.write(Integer.toString(id));
        out.write("\t");
        out.write(Double.toString(parameter));
        out.newLine();
    }
}

