/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchToQuantilesSketchPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ArrayOfDoublesSketchToQuantilesSketchPostAggregatorTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator there = new ArrayOfDoublesSketchToQuantilesSketchPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0), null, null);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator andBackAgain = (ArrayOfDoublesSketchToQuantilesSketchPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), ArrayOfDoublesSketchToQuantilesSketchPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator postAgg = new ArrayOfDoublesSketchToQuantilesSketchPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0), Integer.valueOf(2), Integer.valueOf(16));
        Assert.assertEquals((Object)"ArrayOfDoublesSketchToQuantilesSketchPostAggregator{name='a', field=ConstantPostAggregator{name='', constantValue=0}, column=2, k=16}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        ArrayOfDoublesUpdatableSketch s1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s1.update("foo", new double[]{1.0, 2.0});
        ArrayOfDoublesUpdatableSketch s2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s2.update("foo", new double[]{2.0, 2.0});
        s2.update("bar", new double[]{3.0, 4.0});
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s1).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s2).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2});
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator postAgg1 = new ArrayOfDoublesSketchToQuantilesSketchPostAggregator("a", field1, null, null);
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator postAgg2 = new ArrayOfDoublesSketchToQuantilesSketchPostAggregator("a", field2, null, null);
        Comparator comparator = postAgg1.getComparator();
        DoublesSketch sketch1 = postAgg1.compute((Map)ImmutableMap.of());
        DoublesSketch sketch2 = postAgg2.compute((Map)ImmutableMap.of());
        Assert.assertEquals((long)-1L, (long)comparator.compare(sketch1, sketch2));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchToQuantilesSketchPostAggregator.class).withNonnullFields(new String[]{"name", "field"}).withIgnoredFields(new String[]{"dependentFields"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArrayOfDoublesSketchToQuantilesSketchPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0), Integer.valueOf(2), null)}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.COMPLEX).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

