/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.core.JsonProcessingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchToMeansPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ArrayOfDoublesSketchToMeansPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws JsonProcessingException {
        ArrayOfDoublesSketchToMeansPostAggregator there = new ArrayOfDoublesSketchToMeansPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ArrayOfDoublesSketchToMeansPostAggregator andBackAgain = (ArrayOfDoublesSketchToMeansPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), ArrayOfDoublesSketchToMeansPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        ArrayOfDoublesSketchToMeansPostAggregator postAgg = new ArrayOfDoublesSketchToMeansPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0));
        Assert.assertEquals((Object)"ArrayOfDoublesSketchToMeansPostAggregator{name='a', field=ConstantPostAggregator{name='', constantValue=0}}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Comparing arrays of mean values is not supported");
        ArrayOfDoublesSketchToMeansPostAggregator postAgg = new ArrayOfDoublesSketchToMeansPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0));
        postAgg.getComparator();
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchToMeansPostAggregator.class).withNonnullFields(new String[]{"name", "field"}).withIgnoredFields(new String[]{"dependentFields"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArrayOfDoublesSketchToMeansPostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.DOUBLE_ARRAY).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

