/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchToEstimatePostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ArrayOfDoublesSketchToEstimatePostAggregatorTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        ArrayOfDoublesSketchToEstimatePostAggregator there = new ArrayOfDoublesSketchToEstimatePostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ArrayOfDoublesSketchToEstimatePostAggregator andBackAgain = (ArrayOfDoublesSketchToEstimatePostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), ArrayOfDoublesSketchToEstimatePostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        ArrayOfDoublesSketchToEstimatePostAggregator postAgg = new ArrayOfDoublesSketchToEstimatePostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0));
        Assert.assertEquals((Object)"ArrayOfDoublesSketchToEstimatePostAggregator{name='a', field=ConstantPostAggregator{name='', constantValue=0}}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        ArrayOfDoublesUpdatableSketch s1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s1.update("foo", new double[]{1.0, 2.0});
        ArrayOfDoublesUpdatableSketch s2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s2.update("foo", new double[]{2.0, 2.0});
        s2.update("bar", new double[]{3.0, 4.0});
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s1).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s2).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2});
        ArrayOfDoublesSketchToEstimatePostAggregator postAgg1 = new ArrayOfDoublesSketchToEstimatePostAggregator("a", field1);
        ArrayOfDoublesSketchToEstimatePostAggregator postAgg2 = new ArrayOfDoublesSketchToEstimatePostAggregator("a", field2);
        Double estimate1 = postAgg1.compute((Map)ImmutableMap.of());
        Double estimate2 = postAgg2.compute((Map)ImmutableMap.of());
        Assert.assertEquals((long)-1L, (long)postAgg1.getComparator().compare(estimate1, estimate2));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchToEstimatePostAggregator.class).withNonnullFields(new String[]{"name", "field"}).withIgnoredFields(new String[]{"dependentFields"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArrayOfDoublesSketchToEstimatePostAggregator("a", (PostAggregator)new ConstantPostAggregator("", (Number)0))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

