/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchTTestPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ArrayOfDoublesSketchTTestPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testConstructorTooFewPostAggInputs() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Illegal number of fields[1], must be 2");
        new ArrayOfDoublesSketchTTestPostAggregator("a", (List)ImmutableList.of((Object)new ConstantPostAggregator("", (Number)0)));
    }

    @Test
    public void testConstructorTooManyPostAggInputs() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Illegal number of fields[3], must be 2");
        new ArrayOfDoublesSketchTTestPostAggregator("a", Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ArrayOfDoublesSketchTTestPostAggregator there = new ArrayOfDoublesSketchTTestPostAggregator("a", Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ArrayOfDoublesSketchTTestPostAggregator andBackAgain = (ArrayOfDoublesSketchTTestPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), ArrayOfDoublesSketchTTestPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        ArrayOfDoublesSketchTTestPostAggregator postAgg = new ArrayOfDoublesSketchTTestPostAggregator("a", Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
        Assert.assertEquals((Object)"ArrayOfDoublesSketchTTestPostAggregator{name='a', fields=[ConstantPostAggregator{name='', constantValue=0}, ConstantPostAggregator{name='', constantValue=0}]}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Comparing arrays of p values is not supported");
        ArrayOfDoublesSketchTTestPostAggregator postAgg = new ArrayOfDoublesSketchTTestPostAggregator("a", Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
        postAgg.getComparator();
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchTTestPostAggregator.class).withNonnullFields(new String[]{"name", "fields"}).withIgnoredFields(new String[]{"dependentFields"}).usingGetClass().verify();
    }

    @Test
    public void testComputeMismatchedSketches() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Sketches have different number of values: 2 and 100");
        ArrayOfDoublesUpdatableSketch s1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        ArrayOfDoublesUpdatableSketch s2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(100).build();
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s1).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s2).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2});
        new ArrayOfDoublesSketchTTestPostAggregator("a", Arrays.asList(field1, field2)).compute((Map)ImmutableMap.of());
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArrayOfDoublesSketchTTestPostAggregator("a", (List)ImmutableList.of((Object)new ConstantPostAggregator("", (Number)0), (Object)new ConstantPostAggregator("", (Number)0)))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.DOUBLE_ARRAY).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

