/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchSetOpPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ArrayOfDoublesSketchSetOpPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testConstructorNumArgs() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Illegal number of fields[0], must be > 1");
        ArrayOfDoublesSketchSetOpPostAggregator there = new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", null, null, (List)ImmutableList.of());
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ArrayOfDoublesSketchSetOpPostAggregator there = new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", null, null, Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ArrayOfDoublesSketchSetOpPostAggregator andBackAgain = (ArrayOfDoublesSketchSetOpPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), ArrayOfDoublesSketchSetOpPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        ArrayOfDoublesSketchSetOpPostAggregator postAgg = new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", Integer.valueOf(16), Integer.valueOf(1000), Arrays.asList(new ConstantPostAggregator("", (Number)0), new ConstantPostAggregator("", (Number)0)));
        Assert.assertEquals((Object)"ArrayOfDoublesSketchSetOpPostAggregator{name='a', fields=[ConstantPostAggregator{name='', constantValue=0}, ConstantPostAggregator{name='', constantValue=0}], operation=UNION, nominalEntries=16, numberOfValues=1000}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        ArrayOfDoublesUpdatableSketch s1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s1.update("foo", new double[]{1.0, 2.0});
        ArrayOfDoublesUpdatableSketch s2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s2.update("foo", new double[]{2.0, 2.0});
        s2.update("bar", new double[]{3.0, 4.0});
        ArrayOfDoublesUpdatableSketch s3 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s3.update("foo", new double[]{1.0, 2.0});
        ArrayOfDoublesUpdatableSketch s4 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
        s4.update("foo", new double[]{2.0, 2.0});
        s4.update("bar", new double[]{3.0, 4.0});
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s1).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s2).anyTimes();
        PostAggregator field3 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field3.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s3).anyTimes();
        PostAggregator field4 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field4.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)s4).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2, field3, field4});
        ArrayOfDoublesSketchSetOpPostAggregator postAgg1 = new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", Integer.valueOf(16), Integer.valueOf(2), (List)ImmutableList.of((Object)field1, (Object)field2));
        ArrayOfDoublesSketchSetOpPostAggregator postAgg2 = new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", Integer.valueOf(16), Integer.valueOf(2), (List)ImmutableList.of((Object)field3, (Object)field4));
        Comparator comparator = postAgg1.getComparator();
        ArrayOfDoublesSketch sketch1 = postAgg1.compute((Map)ImmutableMap.of());
        ArrayOfDoublesSketch sketch2 = postAgg2.compute((Map)ImmutableMap.of());
        Assert.assertEquals((long)0L, (long)comparator.compare(sketch1, sketch2));
        Assert.assertEquals((long)0L, (long)Double.compare(sketch1.getEstimate(), sketch2.getEstimate()));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchSetOpPostAggregator.class).withNonnullFields(new String[]{"name", "fields", "operation"}).withIgnoredFields(new String[]{"dependentFields"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).postAggregators(new PostAggregator[]{new ArrayOfDoublesSketchSetOpPostAggregator("a", "UNION", null, null, (List)ImmutableList.of((Object)new ConstantPostAggregator("", (Number)0), (Object)new ConstantPostAggregator("", (Number)0)))}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("a", ValueType.COMPLEX).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

