/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class ArrayOfDoublesSketchAggregatorFactoryTest {
    @Test
    public void makeAggregateCombiner() {
        ArrayOfDoublesSketchAggregatorFactory aggregatorFactory = new ArrayOfDoublesSketchAggregatorFactory("", "", null, null, null);
        AggregatorFactory combiningFactory = aggregatorFactory.getCombiningFactory();
        AggregateCombiner combiner = combiningFactory.makeAggregateCombiner();
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update("a", new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update("b", new double[]{1.0});
        sketch2.update("c", new double[]{1.0});
        TestObjectColumnSelector selector = new TestObjectColumnSelector((Object[])new ArrayOfDoublesSketch[]{sketch1, sketch2});
        combiner.reset((ColumnValueSelector)selector);
        Assert.assertEquals((double)1.0, (double)((ArrayOfDoublesSketch)combiner.getObject()).getEstimate(), (double)0.0);
        selector.increment();
        combiner.fold((ColumnValueSelector)selector);
        Assert.assertEquals((double)3.0, (double)((ArrayOfDoublesSketch)combiner.getObject()).getEstimate(), (double)0.0);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ArrayOfDoublesSketchAggregatorFactory.class).withNonnullFields(new String[]{"name", "fieldName"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new ArrayOfDoublesSketchAggregatorFactory("arrayOfDoublesSketch", "col", Integer.valueOf(1), (List)ImmutableList.of((Object)"met"), Integer.valueOf(1))}).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("a", "arrayOfDoublesSketch"), new FinalizingFieldAccessPostAggregator("b", "arrayOfDoublesSketch")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("arrayOfDoublesSketch", null).add("a", ValueType.COMPLEX).add("b", ValueType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

