/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchModule;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrayOfDoublesSketchAggregationTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AggregationTestHelper helper;

    public ArrayOfDoublesSketchAggregationTest(GroupByQueryConfig config) {
        ArrayOfDoublesSketchModule module = new ArrayOfDoublesSketchModule();
        module.configure(null);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)module.getJacksonModules(), (GroupByQueryConfig)config, (TemporaryFolder)this.tempFolder);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @After
    public void teardown() throws IOException {
        this.helper.close();
    }

    @Test
    public void ingestingSketches() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_sketch_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"sketch\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024},", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"non_existing_sketch\", \"fieldName\": \"non_existing_sketch\"}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024},", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"non_existing_sketch\", \"fieldName\": \"non_existing_sketch\"}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimateAndBounds\", \"name\": \"estimateAndBounds\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, \"numStdDevs\": 2},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToString\", \"name\": \"summary\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToVariances\", \"name\": \"variances\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}}", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)40.0, (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"non_existing_sketch", (double)0.0, (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)40.0, (double)((Double)row.get(2)), (double)0.0);
        Assert.assertArrayEquals((String)"estimateAndBounds", (double[])new double[]{40.0, 40.0, 40.0}, (double[])((double[])row.get(3)), (double)0.0);
        Assert.assertEquals((String)"union", (double)40.0, (double)((Double)row.get(5)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)40.0, (double)((Double)row.get(6)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(7)), (double)0.0);
        Assert.assertArrayEquals((String)"variances", (double[])new double[]{0.0}, (double[])((double[])row.get(9)), (double)0.0);
        Object obj = row.get(4);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)40L, (long)ds.getN());
        Assert.assertEquals((double)1.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)ds.getMaxValue(), (double)0.0);
        String expectedSummary = "### HeapArrayOfDoublesCompactSketch SUMMARY: \n   Estimate                : 40.0\n   Upper Bound, 95% conf   : 40.0\n   Lower Bound, 95% conf   : 40.0\n   Theta (double)          : 1.0\n   Theta (long)            : 9223372036854775807\n   EstMode?                : false\n   Empty?                  : false\n   Retained Entries        : 40\n   Seed Hash               : 93cc | 37836\n### END SKETCH SUMMARY\n";
        Assert.assertEquals((String)"summary", (Object)"### HeapArrayOfDoublesCompactSketch SUMMARY: \n   Estimate                : 40.0\n   Upper Bound, 95% conf   : 40.0\n   Lower Bound, 95% conf   : 40.0\n   Theta (double)          : 1.0\n   Theta (long)            : 9223372036854775807\n   EstMode?                : false\n   Empty?                  : false\n   Retained Entries        : 40\n   Seed Hash               : 93cc | 37836\n### END SKETCH SUMMARY\n", (Object)row.get(8));
    }

    @Test
    public void ingestingSketchesTwoValues() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_sketch_data_two_values.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"sketch\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024, \"numberOfValues\": 2}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024, \"numberOfValues\": 2}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 2,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {", "      \"type\": \"arrayOfDoublesSketchToMeans\",", "      \"name\": \"means\",", "      \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}", "    }", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)40.0, (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)40.0, (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"union", (double)40.0, (double)((Double)row.get(3)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)40.0, (double)((Double)row.get(4)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(5)), (double)0.0);
        Object meansObj = row.get(6);
        Assert.assertTrue((boolean)(meansObj instanceof double[]));
        double[] means = (double[])meansObj;
        Assert.assertEquals((long)2L, (long)means.length);
        Assert.assertEquals((double)1.0, (double)means[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)means[1], (double)0.0);
        Object quantilesObj = row.get(2);
        Assert.assertTrue((boolean)(quantilesObj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)quantilesObj;
        Assert.assertEquals((long)40L, (long)ds.getN());
        Assert.assertEquals((double)1.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)ds.getMaxValue(), (double)0.0);
    }

    @Test
    public void buildingSketchesAtIngestionTime() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"key\", \"value\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"key\", \"metricColumns\": [\"value\"], \"nominalEntries\": 1024}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"size\": 1024}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }}", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)40.0, (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)40.0, (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"union", (double)40.0, (double)((Double)row.get(3)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)40.0, (double)((Double)row.get(4)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(5)), (double)0.0);
        Object obj = row.get(2);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)40L, (long)ds.getN());
        Assert.assertEquals((double)1.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)ds.getMaxValue(), (double)0.0);
    }

    @Test
    public void buildingSketchesAtIngestionTimeTwoValues() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_build_data_two_values.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"key\", \"value1\", \"value2\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"key\", \"metricColumns\": [ \"value1\", \"value2\" ], \"nominalEntries\": 1024}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024, \"numberOfValues\": 2}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"column\": 2, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 2,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 2,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 2,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {", "      \"type\": \"arrayOfDoublesSketchToMeans\",", "      \"name\": \"means\",", "      \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}", "    }", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)40.0, (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)40.0, (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"union", (double)40.0, (double)((Double)row.get(3)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)40.0, (double)((Double)row.get(4)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(5)), (double)0.0);
        Object meansObj = row.get(6);
        Assert.assertTrue((boolean)(meansObj instanceof double[]));
        double[] means = (double[])meansObj;
        Assert.assertEquals((long)2L, (long)means.length);
        Assert.assertEquals((double)1.0, (double)means[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)means[1], (double)0.0);
        Object obj = row.get(2);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)40L, (long)ds.getN());
        Assert.assertEquals((double)2.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)ds.getMaxValue(), (double)0.0);
    }

    @Test
    public void buildingSketchesAtIngestionTimeThreeValuesAndNulls() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_build_data_three_values_and_nulls.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"key\", \"value1\", \"value2\", \"value3\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"key\", \"metricColumns\": [ \"value1\", \"value2\", \"value3\" ], \"nominalEntries\": 1024}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"nominalEntries\": 1024, \"numberOfValues\": 3}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"column\": 2, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {", "      \"type\": \"arrayOfDoublesSketchToMeans\",", "      \"name\": \"means\",", "      \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}", "    },", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch-with-nulls\", \"column\": 3, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}}", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"union", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(3)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(4)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(5)), (double)0.0);
        Object meansObj = row.get(6);
        Assert.assertTrue((boolean)(meansObj instanceof double[]));
        double[] means = (double[])meansObj;
        Assert.assertEquals((long)3L, (long)means.length);
        Assert.assertEquals((double)1.0, (double)means[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)means[1], (double)0.0);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 2.25 : 3.0), (double)means[2], (double)0.1);
        Object obj = row.get(2);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)(NullHandling.replaceWithDefault() ? 40L : 30L), (long)ds.getN());
        Assert.assertEquals((double)2.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)ds.getMaxValue(), (double)0.0);
        Object objSketch2 = row.get(7);
        Assert.assertTrue((boolean)(objSketch2 instanceof DoublesSketch));
        DoublesSketch ds2 = (DoublesSketch)objSketch2;
        Assert.assertEquals((long)(NullHandling.replaceWithDefault() ? 40L : 30L), (long)ds2.getN());
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 0.0 : 3.0), (double)ds2.getMinValue(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)ds2.getMaxValue(), (double)0.0);
    }

    @Test
    public void buildingSketchesAtQueryTime() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\", \"key\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"key\", \"value\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"doubleSum\", \"name\": \"value\", \"fieldName\": \"value\"}", "]"), 0L, Granularities.NONE, 40, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"key\", \"metricColumns\": [\"value\"], \"nominalEntries\": 1024},", "    {\"type\": \"count\", \"name\":\"cnt\"}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }}", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"cnt", (double)40.0, (double)new Double(row.get(1).toString()), (double)0.0);
        Assert.assertEquals((String)"sketch", (double)40.0, (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)40.0, (double)new Double(row.get(2).toString()), (double)0.0);
        Assert.assertEquals((String)"union", (double)40.0, (double)new Double(row.get(4).toString()), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)40.0, (double)new Double(row.get(5).toString()), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)new Double(row.get(6).toString()), (double)0.0);
        Object obj = row.get(3);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)40L, (long)ds.getN());
        Assert.assertEquals((double)1.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)ds.getMaxValue(), (double)0.0);
    }

    @Test
    public void buildingSketchesAtQueryTimeTwoBucketsTest() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/bucket_test_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMdd\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"label\", \"userid\"]", "    },", "    \"columns\": [\"timestamp\", \"label\", \"userid\", \"parameter\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"doubleSum\", \"name\": \"parameter\", \"fieldName\": \"parameter\"}", "]"), 0L, Granularities.NONE, 2000, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {", "      \"type\": \"filtered\",", "      \"filter\": {\"type\": \"selector\", \"dimension\": \"label\", \"value\": \"test\"},", "      \"aggregator\": {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch-test\", \"fieldName\": \"userid\", \"metricColumns\": [\"parameter\"]}", "    },", "    {", "      \"type\": \"filtered\",", "      \"filter\": {\"type\": \"selector\", \"dimension\": \"label\", \"value\": \"control\"},", "      \"aggregator\": {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch-control\", \"fieldName\": \"userid\", \"metricColumns\": [\"parameter\"]}", "    }", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchTTest\",", "      \"name\": \"p-value\", \"fields\": [", "        {\"type\": \"fieldAccess\", \"fieldName\": \"sketch-test\"},", "        {\"type\": \"fieldAccess\", \"fieldName\": \"sketch-control\"}", "      ]", "    }", "  ],", "  \"intervals\": [\"2017-01-01T00:00:00.000Z/2017-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Object obj = row.get(2);
        Assert.assertTrue((boolean)(obj instanceof double[]));
        double[] array = (double[])obj;
        Assert.assertEquals((long)1L, (long)array.length);
        double pValue = array[0];
        Assert.assertEquals((double)0.0, (double)pValue, (double)0.001);
    }

    @Test
    public void buildingSketchesAtQueryTimeWithNullsTest() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tuple/array_of_doubles_build_data_three_values_and_nulls.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\", \"key\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"key\", \"value1\", \"value2\", \"value3\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"doubleSum\", \"name\": \"value1\", \"fieldName\": \"value1\"},", "  {\"type\": \"doubleSum\", \"name\": \"value2\", \"fieldName\": \"value2\"},", "  {\"type\": \"doubleSum\", \"name\": \"value3\", \"fieldName\": \"value3\"}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"virtualColumns\": [{\"type\": \"expression\",\"name\": \"nonulls3\",\"expression\": \"nvl(value3, 0.0)\",\"outputType\": \"DOUBLE\"}],", "  \"aggregations\": [", "   {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"key\", \"metricColumns\": [ \"value1\", \"value2\", \"value3\" ], \"nominalEntries\": 1024},", "   {\"type\": \"arrayOfDoublesSketch\", \"name\": \"sketchNoNulls\", \"fieldName\": \"key\", \"metricColumns\": [ \"value1\", \"value2\", \"nonulls3\" ], \"nominalEntries\": 1024}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimate\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"estimateNoNulls\", \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchNoNulls\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch\", \"column\": 2, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"union\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"union\",", "      \"operation\": \"UNION\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"intersection\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"intersection\",", "      \"operation\": \"INTERSECT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {\"type\": \"arrayOfDoublesSketchToEstimate\", \"name\": \"anotb\", \"field\": {", "      \"type\": \"arrayOfDoublesSketchSetOp\",", "      \"name\": \"anotb\",", "      \"operation\": \"NOT\",", "      \"nominalEntries\": 1024,", "      \"numberOfValues\": 3,", "      \"fields\": [{\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}, {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}]", "    }},", "    {", "      \"type\": \"arrayOfDoublesSketchToMeans\",", "      \"name\": \"means\",", "      \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}", "    },", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch-with-nulls\", \"column\": 3, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"arrayOfDoublesSketchToQuantilesSketch\", \"name\": \"quantiles-sketch-with-no-nulls\", \"column\": 3, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchNoNulls\"}}", "  ],", "  \"intervals\": [\"2015-01-01T00:00:00.000Z/2015-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((String)"sketch", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(0)), (double)0.0);
        Assert.assertEquals((String)"sketchNoNulls", (double)40.0, (double)((Double)row.get(1)), (double)0.0);
        Assert.assertEquals((String)"estimate", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(2)), (double)0.0);
        Assert.assertEquals((String)"estimateNoNulls", (double)40.0, (double)((Double)row.get(3)), (double)0.0);
        Assert.assertEquals((String)"union", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(5)), (double)0.0);
        Assert.assertEquals((String)"intersection", (double)(NullHandling.replaceWithDefault() ? 40.0 : 30.0), (double)((Double)row.get(6)), (double)0.0);
        Assert.assertEquals((String)"anotb", (double)0.0, (double)((Double)row.get(7)), (double)0.0);
        Object meansObj = row.get(8);
        Assert.assertTrue((boolean)(meansObj instanceof double[]));
        double[] means = (double[])meansObj;
        Assert.assertEquals((long)3L, (long)means.length);
        Assert.assertEquals((double)1.0, (double)means[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)means[1], (double)0.0);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 2.25 : 3.0), (double)means[2], (double)0.1);
        Object obj = row.get(4);
        Assert.assertTrue((boolean)(obj instanceof DoublesSketch));
        DoublesSketch ds = (DoublesSketch)obj;
        Assert.assertEquals((long)(NullHandling.replaceWithDefault() ? 40L : 30L), (long)ds.getN());
        Assert.assertEquals((double)2.0, (double)ds.getMinValue(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)ds.getMaxValue(), (double)0.0);
        Object objSketch2 = row.get(9);
        Assert.assertTrue((boolean)(objSketch2 instanceof DoublesSketch));
        DoublesSketch ds2 = (DoublesSketch)objSketch2;
        Assert.assertEquals((long)(NullHandling.replaceWithDefault() ? 40L : 30L), (long)ds2.getN());
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 0.0 : 3.0), (double)ds2.getMinValue(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)ds2.getMaxValue(), (double)0.0);
        Object objSketch3 = row.get(10);
        Assert.assertTrue((boolean)(objSketch3 instanceof DoublesSketch));
        DoublesSketch ds3 = (DoublesSketch)objSketch3;
        Assert.assertEquals((long)40L, (long)ds3.getN());
        Assert.assertEquals((double)0.0, (double)ds3.getMinValue(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)ds3.getMaxValue(), (double)0.0);
    }
}

