/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.sql;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.aggregation.datasketches.theta.SketchSetPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchApproxCountDistinctSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchEstimateOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchEstimateWithErrorBoundsOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchObjectSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetIntersectOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetNotOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.theta.sql.ThetaSketchSetUnionOperatorConversion;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ThetaSketchSqlAggregatorTest
extends CalciteTestBase {
    private static final String DATA_SOURCE = "foo";
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private static AuthenticationResult authenticationResult;
    private static final Map<String, Object> QUERY_CONTEXT_DEFAULT;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create();
    private SpecificSegmentsQuerySegmentWalker walker;
    private SqlLifecycleFactory sqlLifecycleFactory;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        SketchModule.registerSerde();
        for (Module mod : new SketchModule().getJacksonModules()) {
            CalciteTests.getJsonMapper().registerModule(mod);
            TestHelper.JSON_MAPPER.registerModule(mod);
        }
        QueryableIndex index = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new SketchMergeAggregatorFactory("thetasketch_dim1", "dim1", null, Boolean.valueOf(false), Boolean.valueOf(false), null)}).withRollup(false).build()).rows((Iterable)CalciteTests.ROWS1).buildMMappedIndex();
        this.walker = new SpecificSegmentsQuerySegmentWalker(conglomerate).add(DataSegment.builder().dataSource(DATA_SOURCE).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index);
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of((Object)new ThetaSketchApproxCountDistinctSqlAggregator(), (Object)new ThetaSketchObjectSqlAggregator()), (Set)ImmutableSet.of((Object)new ThetaSketchEstimateOperatorConversion(), (Object)new ThetaSketchEstimateWithErrorBoundsOperatorConversion(), (Object)new ThetaSketchSetIntersectOperatorConversion(), (Object)new ThetaSketchSetUnionOperatorConversion(), (Object)new ThetaSketchSetNotOperatorConversion()));
        SchemaPlus rootSchema = CalciteTests.createMockRootSchema((QueryRunnerFactoryConglomerate)conglomerate, (SpecificSegmentsQuerySegmentWalker)this.walker, (PlannerConfig)plannerConfig, (AuthorizerMapper)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        this.sqlLifecycleFactory = CalciteTests.createSqlLifecycleFactory((PlannerFactory)new PlannerFactory(rootSchema, CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, (QueryRunnerFactoryConglomerate)conglomerate), operatorTable, CalciteTests.createExprMacroTable(), plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid"));
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
    }

    @Test
    public void testApproxCountDistinctThetaSketch() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT_DS_THETA(dim2),\n  APPROX_COUNT_DISTINCT_DS_THETA(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT_DS_THETA(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT_DS_THETA(SUBSTRING(dim2, 1, 1) || 'x'),\n  APPROX_COUNT_DISTINCT_DS_THETA(thetasketch_dim1, 32768),\n  APPROX_COUNT_DISTINCT_DS_THETA(thetasketch_dim1)\nFROM druid.foo";
        List results = sqlLifecycle.runSimple("SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT_DS_THETA(dim2),\n  APPROX_COUNT_DISTINCT_DS_THETA(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT_DS_THETA(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT_DS_THETA(SUBSTRING(dim2, 1, 1) || 'x'),\n  APPROX_COUNT_DISTINCT_DS_THETA(thetasketch_dim1, 32768),\n  APPROX_COUNT_DISTINCT_DS_THETA(thetasketch_dim1)\nFROM druid.foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 2L, 2L, 1L, 2L, 5L, 5L}) : ImmutableList.of((Object)new Object[]{6L, 2L, 2L, 1L, 1L, 5L, 5L});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ValueType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("v1", "concat(substring(\"dim2\", 0, 1),'x')", ValueType.STRING, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a0", "cnt"), (Object)new SketchMergeAggregatorFactory("a1", "dim2", null, null, null, null), (Object)new FilteredAggregatorFactory((AggregatorFactory)new SketchMergeAggregatorFactory("a2", "dim2", null, null, null, null), (DimFilter)BaseCalciteQueryTest.not((DimFilter)BaseCalciteQueryTest.selector((String)"dim2", (String)"", null))), (Object)new SketchMergeAggregatorFactory("a3", "v0", null, null, null, null), (Object)new SketchMergeAggregatorFactory("a4", "v1", null, null, null, null), (Object)new SketchMergeAggregatorFactory("a5", "thetasketch_dim1", Integer.valueOf(32768), null, null, null), (Object)new SketchMergeAggregatorFactory("a6", "thetasketch_dim1", null, null, null, null))).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testAvgDailyCountDistinctThetaSketch() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  AVG(u)\nFROM (SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT_DS_THETA(cnt) AS u FROM druid.foo GROUP BY 1)";
        List results = sqlLifecycle.runSimple("SELECT\n  AVG(u)\nFROM (SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT_DS_THETA(cnt) AS u FROM druid.foo GROUP BY 1)", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1L});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        GroupByQuery expected = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(Collections.singletonList(new SketchMergeAggregatorFactory("a0:a", "cnt", null, null, null, null))).postAggregators((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).context(BaseCalciteQueryTest.getTimeseriesContextWithFloorTime((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy"), (String)"d0")).build())).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setAggregatorSpecs(NullHandling.replaceWithDefault() ? Arrays.asList(new LongSumAggregatorFactory("_a0:sum", "a0"), new CountAggregatorFactory("_a0:count")) : Arrays.asList(new LongSumAggregatorFactory("_a0:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), (DimFilter)BaseCalciteQueryTest.not((DimFilter)BaseCalciteQueryTest.selector((String)"a0", null, null))))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a0:sum"), (Object)new FieldAccessPostAggregator(null, "_a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build();
        Query actual = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testThetaSketchPostAggs() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  SUM(cnt),\n  theta_sketch_estimate(DS_THETA(dim2)),\n  theta_sketch_estimate(DS_THETA(CONCAT(dim2, 'hello'))),\n  theta_sketch_estimate_with_error_bounds(DS_THETA(dim2), 10),\n  THETA_SKETCH_INTERSECT(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_UNION(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_NOT(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_INTERSECT(32768, DS_THETA(dim2), DS_THETA(dim1)),\n  theta_sketch_estimate(THETA_SKETCH_INTERSECT(THETA_SKETCH_INTERSECT(DS_THETA(dim2), DS_THETA(dim1)), DS_THETA(dim2)))\nFROM druid.foo";
        List results = sqlLifecycle.runSimple("SELECT\n  SUM(cnt),\n  theta_sketch_estimate(DS_THETA(dim2)),\n  theta_sketch_estimate(DS_THETA(CONCAT(dim2, 'hello'))),\n  theta_sketch_estimate_with_error_bounds(DS_THETA(dim2), 10),\n  THETA_SKETCH_INTERSECT(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_UNION(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_NOT(DS_THETA(dim2), DS_THETA(dim1)),\n  THETA_SKETCH_INTERSECT(32768, DS_THETA(dim2), DS_THETA(dim1)),\n  theta_sketch_estimate(THETA_SKETCH_INTERSECT(THETA_SKETCH_INTERSECT(DS_THETA(dim2), DS_THETA(dim1)), DS_THETA(dim2)))\nFROM druid.foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 2.0, 3.0, "{\"estimate\":2.0,\"highBound\":2.0,\"lowBound\":2.0,\"numStdDev\":10}", "\"AQMDAAA6zJOQxkPsNomrZQ==\"", "\"AgMDAAAazJMGAAAAAACAP1XTBztMIcMJ+HOoBBne1zKQxkPsNomrZUeWbJt3n+VpF8EdUoUHAXvxsLkOSE0lfQ==\"", "\"AQMDAAA6zJMXwR1ShQcBew==\"", "\"AQMDAAA6zJOQxkPsNomrZQ==\"", 1.0}) : ImmutableList.of((Object)new Object[]{6L, 2.0, 3.0, "{\"estimate\":2.0,\"highBound\":2.0,\"lowBound\":2.0,\"numStdDev\":10}", "\"AQMDAAA6zJOQxkPsNomrZQ==\"", "\"AgMDAAAazJMGAAAAAACAP1XTBztMIcMJ+HOoBBne1zKQxkPsNomrZUeWbJt3n+VpF8EdUoUHAXvxsLkOSE0lfQ==\"", "\"AQMDAAA6zJMXwR1ShQcBew==\"", "\"AQMDAAA6zJOQxkPsNomrZQ==\"", 1.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(\"dim2\",'hello')", ValueType.STRING, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a0", "cnt"), (Object)new SketchMergeAggregatorFactory("a1", "dim2", null, null, null, null), (Object)new SketchMergeAggregatorFactory("a2", "v0", null, null, null, null), (Object)new SketchMergeAggregatorFactory("a3", "dim1", null, null, null, null))).postAggregators(new PostAggregator[]{new SketchEstimatePostAggregator("p1", (PostAggregator)new FieldAccessPostAggregator("p0", "a1"), null), new SketchEstimatePostAggregator("p3", (PostAggregator)new FieldAccessPostAggregator("p2", "a2"), null), new SketchEstimatePostAggregator("p5", (PostAggregator)new FieldAccessPostAggregator("p4", "a1"), Integer.valueOf(10)), new SketchSetPostAggregator("p8", "INTERSECT", null, (List)ImmutableList.of((Object)new FieldAccessPostAggregator("p6", "a1"), (Object)new FieldAccessPostAggregator("p7", "a3"))), new SketchSetPostAggregator("p11", "UNION", null, (List)ImmutableList.of((Object)new FieldAccessPostAggregator("p9", "a1"), (Object)new FieldAccessPostAggregator("p10", "a3"))), new SketchSetPostAggregator("p14", "NOT", null, (List)ImmutableList.of((Object)new FieldAccessPostAggregator("p12", "a1"), (Object)new FieldAccessPostAggregator("p13", "a3"))), new SketchSetPostAggregator("p17", "INTERSECT", Integer.valueOf(32768), (List)ImmutableList.of((Object)new FieldAccessPostAggregator("p15", "a1"), (Object)new FieldAccessPostAggregator("p16", "a3"))), new SketchEstimatePostAggregator("p23", (PostAggregator)new SketchSetPostAggregator("p22", "INTERSECT", null, (List)ImmutableList.of((Object)new SketchSetPostAggregator("p20", "INTERSECT", null, (List)ImmutableList.of((Object)new FieldAccessPostAggregator("p18", "a1"), (Object)new FieldAccessPostAggregator("p19", "a3"))), (Object)new FieldAccessPostAggregator("p21", "a1"))), null)}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    @Test
    public void testThetaSketchPostAggsPostSort() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT DS_THETA(dim2) as y FROM druid.foo ORDER BY THETA_SKETCH_ESTIMATE(DS_THETA(dim2)) DESC LIMIT 10";
        String sql2 = StringUtils.format((String)"SELECT THETA_SKETCH_ESTIMATE(y) from (%s)", (Object[])new Object[]{"SELECT DS_THETA(dim2) as y FROM druid.foo ORDER BY THETA_SKETCH_ESTIMATE(DS_THETA(dim2)) DESC LIMIT 10"});
        List results = sqlLifecycle.runSimple(sql2, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{2.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new SketchMergeAggregatorFactory("a0", "dim2", null, null, null, null))).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("p0", "a0"), new SketchEstimatePostAggregator("p2", (PostAggregator)new FieldAccessPostAggregator("p1", "a0"), null), new SketchEstimatePostAggregator("s1", (PostAggregator)new FieldAccessPostAggregator("s0", "p0"), null)}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    static {
        authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
        QUERY_CONTEXT_DEFAULT = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy");
    }
}

