/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.oldapi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.oldapi.OldApiSketchModule;
import org.apache.druid.query.aggregation.datasketches.theta.oldapi.OldSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.oldapi.OldSketchEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.oldapi.OldSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.oldapi.OldSketchSetPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OldApiSketchAggregationTest
extends InitializedNullHandlingTest {
    private final AggregationTestHelper helper;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public OldApiSketchAggregationTest(GroupByQueryConfig config) {
        OldApiSketchModule sm = new OldApiSketchModule();
        sm.configure(null);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)sm.getJacksonModules(), (GroupByQueryConfig)config, (TemporaryFolder)this.tempFolder);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @After
    public void teardown() throws IOException {
        this.helper.close();
    }

    @Test
    public void testSimpleDataIngestAndQuery() throws Exception {
        String groupByQueryString = OldApiSketchAggregationTest.readFileFromClasspathAsString("oldapi/old_simple_test_data_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("simple_test_data.tsv").getFile()), OldApiSketchAggregationTest.readFileFromClasspathAsString("simple_test_data_record_parser.json"), OldApiSketchAggregationTest.readFileFromClasspathAsString("oldapi/old_simple_test_data_aggregators.json"), 0L, Granularities.NONE, 1000, groupByQueryString);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ResultRow.fromLegacyRow((Row)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"sketch_count", (Object)50.0).put((Object)"sketchEstimatePostAgg", (Object)50.0).put((Object)"sketchUnionPostAggEstimate", (Object)50.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)50.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (GroupByQuery)groupByQuery), results.get(0));
    }

    @Test
    public void testSketchDataIngestAndQuery() throws Exception {
        String groupByQueryString = OldApiSketchAggregationTest.readFileFromClasspathAsString("oldapi/old_sketch_test_data_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(OldApiSketchAggregationTest.class.getClassLoader().getResource("sketch_test_data.tsv").getFile()), OldApiSketchAggregationTest.readFileFromClasspathAsString("sketch_test_data_record_parser.json"), OldApiSketchAggregationTest.readFileFromClasspathAsString("oldapi/old_sketch_test_data_aggregators.json"), 0L, Granularities.NONE, 1000, groupByQueryString);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ResultRow.fromLegacyRow((Row)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"sids_sketch_count", (Object)50.0).put((Object)"sketchEstimatePostAgg", (Object)50.0).put((Object)"sketchUnionPostAggEstimate", (Object)50.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)50.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (GroupByQuery)groupByQuery), results.get(0));
    }

    @Test
    public void testSketchMergeAggregatorFactorySerde() throws Exception {
        this.assertAggregatorFactorySerde((AggregatorFactory)new OldSketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), null));
        this.assertAggregatorFactorySerde((AggregatorFactory)new OldSketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(false)));
        this.assertAggregatorFactorySerde((AggregatorFactory)new OldSketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(true)));
    }

    @Test
    public void testSketchBuildAggregatorFactorySerde() throws Exception {
        this.assertAggregatorFactorySerde((AggregatorFactory)new OldSketchBuildAggregatorFactory("name", "fieldName", Integer.valueOf(16)));
    }

    private void assertAggregatorFactorySerde(AggregatorFactory agg) throws Exception {
        Assert.assertEquals((Object)agg, (Object)this.helper.getObjectMapper().readValue(this.helper.getObjectMapper().writeValueAsString((Object)agg), AggregatorFactory.class));
    }

    @Test
    public void testSketchEstimatePostAggregatorSerde() throws Exception {
        this.assertPostAggregatorSerde((PostAggregator)new OldSketchEstimatePostAggregator("name", (PostAggregator)new FieldAccessPostAggregator("name", "fieldName")));
    }

    @Test
    public void testSketchSetPostAggregatorSerde() throws Exception {
        this.assertPostAggregatorSerde((PostAggregator)new OldSketchSetPostAggregator("name", "INTERSECT", null, (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("name1", "fieldName1"), new FieldAccessPostAggregator("name2", "fieldName2")})));
    }

    @Test
    public void testRelocation() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        SketchHolder sketchHolder = SketchHolder.of((Object)Sketches.updateSketchBuilder().setNominalEntries(16).build());
        UpdateSketch updateSketch = (UpdateSketch)sketchHolder.getSketch();
        updateSketch.update(1L);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"sketch", (Object)sketchHolder)));
        SketchHolder[] holders = (SketchHolder[])this.helper.runRelocateVerificationTest((AggregatorFactory)new OldSketchMergeAggregatorFactory("sketch", "sketch", Integer.valueOf(16), Boolean.valueOf(false)), (ColumnSelectorFactory)columnSelectorFactory, SketchHolder.class);
        Assert.assertEquals((double)holders[0].getEstimate(), (double)holders[1].getEstimate(), (double)0.0);
    }

    private void assertPostAggregatorSerde(PostAggregator agg) throws Exception {
        Assert.assertEquals((Object)agg, (Object)this.helper.getObjectMapper().readValue(this.helper.getObjectMapper().writeValueAsString((Object)agg), PostAggregator.class));
    }

    public static String readFileFromClasspathAsString(String fileName) throws IOException {
        return Files.asCharSource((File)new File(OldApiSketchAggregationTest.class.getClassLoader().getResource(fileName).getFile()), (Charset)StandardCharsets.UTF_8).read();
    }
}

