/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.Family;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchToStringPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SketchToStringPostAggregatorTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        SketchToStringPostAggregator there = new SketchToStringPostAggregator("summary", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SketchToStringPostAggregator andBackAgain = (SketchToStringPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), SketchToStringPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        SketchToStringPostAggregator postAgg = new SketchToStringPostAggregator("summary", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"));
        Assert.assertEquals((Object)"SketchToStringPostAggregator{name='summary', field=FieldAccessPostAggregator{name='field', fieldName='sketch'}}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        Union u1 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u1.update(10L);
        Union u2 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u2.update(20L);
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u1)).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2});
        SketchToStringPostAggregator postAgg1 = new SketchToStringPostAggregator("summary", field1);
        SketchToStringPostAggregator postAgg2 = new SketchToStringPostAggregator("summary", field2);
        String summary1 = (String)postAgg1.compute((Map)ImmutableMap.of());
        String summary2 = (String)postAgg2.compute((Map)ImmutableMap.of());
        Assert.assertEquals((long)0L, (long)postAgg1.getComparator().compare(summary1, summary2));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(SketchToStringPostAggregator.class).withNonnullFields(new String[]{"name", "field"}).usingGetClass().verify();
    }

    @Test
    public void testCompute() {
        TestObjectColumnSelector selector = new TestObjectColumnSelector(new Object[0]);
        SketchAggregator agg = new SketchAggregator((BaseObjectColumnValueSelector)selector, 4096);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        SketchToStringPostAggregator postAgg = new SketchToStringPostAggregator("summary", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"));
        String summary = (String)postAgg.compute(fields);
        Assert.assertNotNull((Object)summary);
        Assert.assertTrue((boolean)summary.contains("SUMMARY"));
    }
}

