/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.Family;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchSetPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SketchSetPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testConstructorNumFields() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Illegal number of fields[0], must be > 1");
        new SketchSetPostAggregator("summary", "UNION", null, (List)ImmutableList.of());
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        List<PostAggregator> fields = Arrays.asList(new FieldAccessPostAggregator("field1", "sketch"), new FieldAccessPostAggregator("field2", "sketch"));
        SketchSetPostAggregator union = new SketchSetPostAggregator("summary", "UNION", null, fields);
        SketchSetPostAggregator intersect = new SketchSetPostAggregator("summary", "INTERSECT", null, fields);
        SketchSetPostAggregator not = new SketchSetPostAggregator("summary", "NOT", null, fields);
        List<PostAggregator> serdeTests = Arrays.asList(union, intersect, not);
        for (PostAggregator there : serdeTests) {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            SketchSetPostAggregator andBackAgain = (SketchSetPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), SketchSetPostAggregator.class);
            Assert.assertEquals((Object)there, (Object)andBackAgain);
            Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
        }
    }

    @Test
    public void testToString() {
        SketchSetPostAggregator postAgg = new SketchSetPostAggregator("summary", "UNION", null, Arrays.asList(new FieldAccessPostAggregator("field1", "sketch"), new FieldAccessPostAggregator("field2", "sketch")));
        Assert.assertEquals((Object)"SketchSetPostAggregator{name='summary', fields=[FieldAccessPostAggregator{name='field1', fieldName='sketch'}, FieldAccessPostAggregator{name='field2', fieldName='sketch'}], func=UNION, size=16384}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        Union u1 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u1.update(10L);
        Union u2 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u2.update(20L);
        Union u3 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u3.update(10L);
        Union u4 = (Union)SetOperation.builder().setNominalEntries(10).build(Family.UNION);
        u4.update(20L);
        PostAggregator field1 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field1.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u1)).anyTimes();
        PostAggregator field2 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field2.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u2)).anyTimes();
        PostAggregator field3 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field3.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u3)).anyTimes();
        PostAggregator field4 = (PostAggregator)EasyMock.createMock(PostAggregator.class);
        EasyMock.expect((Object)field4.compute((Map)EasyMock.anyObject(Map.class))).andReturn((Object)SketchHolder.of((Object)u4)).anyTimes();
        EasyMock.replay((Object[])new Object[]{field1, field2, field3, field4});
        SketchSetPostAggregator postAgg1 = new SketchSetPostAggregator("summary", "UNION", null, Arrays.asList(field1, field2));
        SketchSetPostAggregator postAgg2 = new SketchSetPostAggregator("summary", "UNION", null, Arrays.asList(field3, field4));
        SketchHolder holder1 = (SketchHolder)postAgg1.compute((Map)ImmutableMap.of());
        SketchHolder holder2 = (SketchHolder)postAgg2.compute((Map)ImmutableMap.of());
        Assert.assertEquals((long)0L, (long)postAgg1.getComparator().compare(holder1, holder2));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(SketchSetPostAggregator.class).withNonnullFields(new String[]{"name", "fields"}).usingGetClass().verify();
    }
}

