/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregationTest;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SketchAggregationWithSimpleDataTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final GroupByQueryConfig config;
    private SketchModule sm;
    private File s1;
    private File s2;

    public SketchAggregationWithSimpleDataTest(GroupByQueryConfig config) {
        this.config = config;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @Before
    public void setup() throws Exception {
        SketchModule.registerSerde();
        this.sm = new SketchModule();
        try (AggregationTestHelper toolchest = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)this.sm.getJacksonModules(), (GroupByQueryConfig)this.config, (TemporaryFolder)this.tempFolder);){
            this.s1 = this.tempFolder.newFolder();
            toolchest.createIndex(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("simple_test_data.tsv").getFile()), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("simple_test_data_record_parser.json"), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("simple_test_data_aggregators.json"), this.s1, 0L, Granularities.NONE, 5000);
            this.s2 = this.tempFolder.newFolder();
            toolchest.createIndex(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("simple_test_data.tsv").getFile()), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("simple_test_data_record_parser.json"), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("simple_test_data_aggregators.json"), this.s2, 0L, Granularities.NONE, 5000);
        }
    }

    @Test
    public void testSimpleDataIngestAndGpByQuery() throws Exception {
        try (AggregationTestHelper gpByQueryAggregationTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)this.sm.getJacksonModules(), (GroupByQueryConfig)this.config, (TemporaryFolder)this.tempFolder);){
            String groupByQueryString = SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("simple_test_data_group_by_query.json");
            GroupByQuery groupByQuery = (GroupByQuery)gpByQueryAggregationTestHelper.getObjectMapper().readValue(groupByQueryString, Query.class);
            Sequence seq = gpByQueryAggregationTestHelper.runQueryOnSegments((List)ImmutableList.of((Object)this.s1, (Object)this.s2), groupByQueryString);
            List results = seq.map(row -> row.toMapBasedRow(groupByQuery)).toList();
            Assert.assertEquals((long)5L, (long)results.size());
            Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_3").put((Object)"sketch_count", (Object)38.0).put((Object)"sketchEstimatePostAgg", (Object)38.0).put((Object)"sketchUnionPostAggEstimate", (Object)38.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)38.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_1").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_2").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_4").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_5").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build())), (Object)results);
        }
    }

    @Test
    public void testSimpleDataIngestAndTimeseriesQuery() throws Exception {
        AggregationTestHelper timeseriesQueryAggregationTestHelper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper((List)this.sm.getJacksonModules(), (TemporaryFolder)this.tempFolder);
        Sequence seq = timeseriesQueryAggregationTestHelper.runQueryOnSegments((List)ImmutableList.of((Object)this.s1, (Object)this.s2), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("timeseries_query.json"));
        Result result = (Result)Iterables.getOnlyElement((Iterable)seq.toList());
        Assert.assertEquals((Object)DateTimes.of((String)"2014-10-20T00:00:00.000Z"), (Object)result.getTimestamp());
        Assert.assertEquals((double)50.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("sketch_count"), (double)0.01);
        Assert.assertEquals((double)50.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("sketchEstimatePostAgg"), (double)0.01);
        Assert.assertEquals((double)50.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("sketchUnionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)50.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("sketchIntersectionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)0.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("sketchAnotBPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)0.0, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("non_existing_col_validation"), (double)0.01);
    }

    @Test
    public void testSimpleDataIngestAndTopNQuery() throws Exception {
        AggregationTestHelper topNQueryAggregationTestHelper = AggregationTestHelper.createTopNQueryAggregationTestHelper((List)this.sm.getJacksonModules(), (TemporaryFolder)this.tempFolder);
        Sequence seq = topNQueryAggregationTestHelper.runQueryOnSegments((List)ImmutableList.of((Object)this.s1, (Object)this.s2), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("topn_query.json"));
        Result result = (Result)Iterables.getOnlyElement((Iterable)seq.toList());
        Assert.assertEquals((Object)DateTimes.of((String)"2014-10-20T00:00:00.000Z"), (Object)result.getTimestamp());
        DimensionAndMetricValueExtractor value = (DimensionAndMetricValueExtractor)Iterables.getOnlyElement((Iterable)((TopNResultValue)result.getValue()).getValue());
        Assert.assertEquals((double)38.0, (double)value.getDoubleMetric("sketch_count"), (double)0.01);
        Assert.assertEquals((double)38.0, (double)value.getDoubleMetric("sketchEstimatePostAgg"), (double)0.01);
        Assert.assertEquals((double)38.0, (double)value.getDoubleMetric("sketchUnionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)38.0, (double)value.getDoubleMetric("sketchIntersectionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)0.0, (double)value.getDoubleMetric("sketchAnotBPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)0.0, (double)value.getDoubleMetric("non_existing_col_validation"), (double)0.01);
        Assert.assertEquals((Object)"product_3", (Object)value.getDimensionValue("product"));
    }

    @Test
    public void testTopNQueryWithSketchConstant() throws Exception {
        AggregationTestHelper topNQueryAggregationTestHelper = AggregationTestHelper.createTopNQueryAggregationTestHelper((List)this.sm.getJacksonModules(), (TemporaryFolder)this.tempFolder);
        Sequence seq = topNQueryAggregationTestHelper.runQueryOnSegments((List)ImmutableList.of((Object)this.s1, (Object)this.s2), SketchAggregationWithSimpleDataTest.readFileFromClasspathAsString("topn_query_sketch_const.json"));
        Result result = (Result)Iterables.getOnlyElement((Iterable)seq.toList());
        Assert.assertEquals((Object)DateTimes.of((String)"2014-10-20T00:00:00.000Z"), (Object)result.getTimestamp());
        DimensionAndMetricValueExtractor value1 = (DimensionAndMetricValueExtractor)Iterables.get((Iterable)((TopNResultValue)result.getValue()).getValue(), (int)0);
        Assert.assertEquals((double)38.0, (double)value1.getDoubleMetric("sketch_count"), (double)0.01);
        Assert.assertEquals((double)38.0, (double)value1.getDoubleMetric("sketchEstimatePostAgg"), (double)0.01);
        Assert.assertEquals((double)2.0, (double)value1.getDoubleMetric("sketchEstimatePostAggForSketchConstant"), (double)0.01);
        Assert.assertEquals((double)39.0, (double)value1.getDoubleMetric("sketchUnionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)1.0, (double)value1.getDoubleMetric("sketchIntersectionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)37.0, (double)value1.getDoubleMetric("sketchAnotBPostAggEstimate"), (double)0.01);
        Assert.assertEquals((Object)"product_3", (Object)value1.getDimensionValue("product"));
        DimensionAndMetricValueExtractor value2 = (DimensionAndMetricValueExtractor)Iterables.get((Iterable)((TopNResultValue)result.getValue()).getValue(), (int)1);
        Assert.assertEquals((double)42.0, (double)value2.getDoubleMetric("sketch_count"), (double)0.01);
        Assert.assertEquals((double)42.0, (double)value2.getDoubleMetric("sketchEstimatePostAgg"), (double)0.01);
        Assert.assertEquals((double)2.0, (double)value2.getDoubleMetric("sketchEstimatePostAggForSketchConstant"), (double)0.01);
        Assert.assertEquals((double)42.0, (double)value2.getDoubleMetric("sketchUnionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)2.0, (double)value2.getDoubleMetric("sketchIntersectionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)40.0, (double)value2.getDoubleMetric("sketchAnotBPostAggEstimate"), (double)0.01);
        Assert.assertEquals((Object)"product_1", (Object)value2.getDimensionValue("product"));
        DimensionAndMetricValueExtractor value3 = (DimensionAndMetricValueExtractor)Iterables.get((Iterable)((TopNResultValue)result.getValue()).getValue(), (int)2);
        Assert.assertEquals((double)42.0, (double)value3.getDoubleMetric("sketch_count"), (double)0.01);
        Assert.assertEquals((double)42.0, (double)value3.getDoubleMetric("sketchEstimatePostAgg"), (double)0.01);
        Assert.assertEquals((double)2.0, (double)value3.getDoubleMetric("sketchEstimatePostAggForSketchConstant"), (double)0.01);
        Assert.assertEquals((double)42.0, (double)value3.getDoubleMetric("sketchUnionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)2.0, (double)value3.getDoubleMetric("sketchIntersectionPostAggEstimate"), (double)0.01);
        Assert.assertEquals((double)40.0, (double)value3.getDoubleMetric("sketchAnotBPostAggEstimate"), (double)0.01);
        Assert.assertEquals((Object)"product_2", (Object)value3.getDimensionValue("product"));
    }

    public static String readFileFromClasspathAsString(String fileName) throws IOException {
        return Files.asCharSource((File)new File(SketchAggregationTest.class.getClassLoader().getResource(fileName).getFile()), (Charset)StandardCharsets.UTF_8).read();
    }
}

