/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.datasketches.Family;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchConstantPostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimateWithErrorBounds;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.aggregation.datasketches.theta.SketchSetPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SketchAggregationTest {
    private final AggregationTestHelper helper;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public SketchAggregationTest(GroupByQueryConfig config) {
        SketchModule.registerSerde();
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)new SketchModule().getJacksonModules(), (GroupByQueryConfig)config, (TemporaryFolder)this.tempFolder);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @After
    public void teardown() throws IOException {
        this.helper.close();
    }

    @Test
    public void testSketchDataIngestAndGpByQuery() throws Exception {
        String groupByQueryString = SketchAggregationTest.readFileFromClasspathAsString("sketch_test_data_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(SketchAggregationTest.class.getClassLoader().getResource("sketch_test_data.tsv").getFile()), SketchAggregationTest.readFileFromClasspathAsString("sketch_test_data_record_parser.json"), SketchAggregationTest.readFileFromClasspathAsString("sketch_test_data_aggregators.json"), 0L, Granularities.NONE, 1000, groupByQueryString);
        String expectedSummary = "\n### HeapCompactOrderedSketch SUMMARY: \n   Estimate                : 50.0\n   Upper Bound, 95% conf   : 50.0\n   Lower Bound, 95% conf   : 50.0\n   Theta (double)          : 1.0\n   Theta (long)            : 9223372036854775807\n   Theta (long) hex        : 7fffffffffffffff\n   EstMode?                : false\n   Empty?                  : false\n   Retained Entries        : 50\n   Seed Hash               : 93cc | 37836\n### END SKETCH SUMMARY\n";
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ResultRow.fromLegacyRow((Row)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"sids_sketch_count", (Object)50.0).put((Object)"sids_sketch_count_with_err", (Object)new SketchEstimateWithErrorBounds(50.0, 50.0, 50.0, 2)).put((Object)"sketchEstimatePostAgg", (Object)50.0).put((Object)"sketchEstimatePostAggWithErrorBounds", (Object)new SketchEstimateWithErrorBounds(50.0, 50.0, 50.0, 2)).put((Object)"sketchUnionPostAggEstimate", (Object)50.0).put((Object)"sketchSummary", (Object)"\n### HeapCompactOrderedSketch SUMMARY: \n   Estimate                : 50.0\n   Upper Bound, 95% conf   : 50.0\n   Lower Bound, 95% conf   : 50.0\n   Theta (double)          : 1.0\n   Theta (long)            : 9223372036854775807\n   Theta (long) hex        : 7fffffffffffffff\n   EstMode?                : false\n   Empty?                  : false\n   Retained Entries        : 50\n   Seed Hash               : 93cc | 37836\n### END SKETCH SUMMARY\n").put((Object)"sketchIntersectionPostAggEstimate", (Object)50.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (GroupByQuery)groupByQuery), results.get(0));
    }

    @Test
    public void testEmptySketchAggregateCombine() throws Exception {
        String groupByQueryString = SketchAggregationTest.readFileFromClasspathAsString("empty_sketch_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(SketchAggregationTest.class.getClassLoader().getResource("empty_sketch_data.tsv").getFile()), SketchAggregationTest.readFileFromClasspathAsString("empty_sketch_data_record_parser.json"), SketchAggregationTest.readFileFromClasspathAsString("empty_sketch_test_data_aggregators.json"), 0L, Granularities.NONE, 5, groupByQueryString);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ResultRow.fromLegacyRow((Row)new MapBasedRow(DateTimes.of((String)"2019-07-14T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_b").put((Object)"sketch_count", (Object)0.0).build()), (GroupByQuery)groupByQuery), results.get(0));
    }

    @Test
    public void testThetaCardinalityOnSimpleColumn() throws Exception {
        String groupByQueryString = SketchAggregationTest.readFileFromClasspathAsString("simple_test_data_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(SketchAggregationTest.class.getClassLoader().getResource("simple_test_data.tsv").getFile()), SketchAggregationTest.readFileFromClasspathAsString("simple_test_data_record_parser2.json"), "[  {    \"type\": \"count\",    \"name\": \"count\"  }]", 0L, Granularities.NONE, 1000, groupByQueryString);
        List results = seq.toList();
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertEquals(ImmutableList.of((Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_3").put((Object)"sketch_count", (Object)38.0).put((Object)"sketchEstimatePostAgg", (Object)38.0).put((Object)"sketchUnionPostAggEstimate", (Object)38.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)38.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_1").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_2").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_4").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build()), (Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_5").put((Object)"sketch_count", (Object)42.0).put((Object)"sketchEstimatePostAgg", (Object)42.0).put((Object)"sketchUnionPostAggEstimate", (Object)42.0).put((Object)"sketchIntersectionPostAggEstimate", (Object)42.0).put((Object)"sketchAnotBPostAggEstimate", (Object)0.0).put((Object)"non_existing_col_validation", (Object)0.0).build())).stream().map(row -> ResultRow.fromLegacyRow((Row)row, (GroupByQuery)groupByQuery)).collect(Collectors.toList()), (Object)results);
    }

    @Test
    public void testSketchMergeAggregatorFactorySerde() throws Exception {
        this.assertAggregatorFactorySerde((AggregatorFactory)new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), null, null, null));
        this.assertAggregatorFactorySerde((AggregatorFactory)new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(false), Boolean.valueOf(true), null));
        this.assertAggregatorFactorySerde((AggregatorFactory)new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(true), Boolean.valueOf(false), null));
        this.assertAggregatorFactorySerde((AggregatorFactory)new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(2)));
    }

    @Test
    public void testSketchMergeFinalization() {
        SketchHolder sketch = SketchHolder.of((Object)Sketches.updateSketchBuilder().setNominalEntries(128).build());
        SketchMergeAggregatorFactory agg = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), null, null, null);
        Assert.assertEquals((double)0.0, (double)((Double)agg.finalizeComputation((Object)sketch)), (double)1.0E-4);
        agg = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(true), null, null);
        Assert.assertEquals((double)0.0, (double)((Double)agg.finalizeComputation((Object)sketch)), (double)1.0E-4);
        agg = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(false), null, null);
        Assert.assertEquals((Object)sketch, (Object)agg.finalizeComputation((Object)sketch));
        agg = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), Boolean.valueOf(true), null, Integer.valueOf(2));
        SketchEstimateWithErrorBounds est = (SketchEstimateWithErrorBounds)agg.finalizeComputation((Object)sketch);
        Assert.assertEquals((double)0.0, (double)est.getEstimate(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)est.getHighBound(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)est.getLowBound(), (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)est.getNumStdDev());
    }

    private void assertAggregatorFactorySerde(AggregatorFactory agg) throws Exception {
        Assert.assertEquals((Object)agg, (Object)this.helper.getObjectMapper().readValue(this.helper.getObjectMapper().writeValueAsString((Object)agg), AggregatorFactory.class));
    }

    @Test
    public void testSketchEstimatePostAggregatorSerde() throws Exception {
        this.assertPostAggregatorSerde((PostAggregator)new SketchEstimatePostAggregator("name", (PostAggregator)new FieldAccessPostAggregator("name", "fieldName"), null));
        this.assertPostAggregatorSerde((PostAggregator)new SketchEstimatePostAggregator("name", (PostAggregator)new FieldAccessPostAggregator("name", "fieldName"), Integer.valueOf(2)));
        this.assertPostAggregatorSerde((PostAggregator)new SketchEstimatePostAggregator("name", (PostAggregator)new SketchConstantPostAggregator("name", "AgMDAAAazJMCAAAAAACAPzz9j7pWTMdROWGf15uY1nI="), null));
    }

    @Test
    public void testSketchSetPostAggregatorSerde() throws Exception {
        this.assertPostAggregatorSerde((PostAggregator)new SketchSetPostAggregator("name", "INTERSECT", null, (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("name1", "fieldName1"), new FieldAccessPostAggregator("name2", "fieldName2")})));
        this.assertPostAggregatorSerde((PostAggregator)new SketchSetPostAggregator("name", "INTERSECT", null, (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("name1", "fieldName1"), new SketchConstantPostAggregator("name2", "AgMDAAAazJMCAAAAAACAPzz9j7pWTMdROWGf15uY1nI=")})));
    }

    @Test
    public void testCacheKey() {
        SketchMergeAggregatorFactory factory1 = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), null, null, null);
        SketchMergeAggregatorFactory factory2 = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(16), null, null, null);
        SketchMergeAggregatorFactory factory3 = new SketchMergeAggregatorFactory("name", "fieldName", Integer.valueOf(32), null, null, null);
        Assert.assertTrue((boolean)Arrays.equals(factory1.getCacheKey(), factory2.getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(factory1.getCacheKey(), factory3.getCacheKey()));
    }

    @Test
    public void testRetentionDataIngestAndGpByQuery() throws Exception {
        String groupByQueryString = SketchAggregationTest.readFileFromClasspathAsString("retention_test_data_group_by_query.json");
        GroupByQuery groupByQuery = (GroupByQuery)this.helper.getObjectMapper().readValue(groupByQueryString, Query.class);
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("retention_test_data.tsv").getFile()), SketchAggregationTest.readFileFromClasspathAsString("simple_test_data_record_parser.json"), SketchAggregationTest.readFileFromClasspathAsString("simple_test_data_aggregators.json"), 0L, Granularities.NONE, 5, groupByQueryString);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals(ImmutableList.of((Object)new MapBasedRow(DateTimes.of((String)"2014-10-19T00:00:00.000Z"), (Map)ImmutableMap.builder().put((Object)"product", (Object)"product_1").put((Object)"p1_unique_country_day_1", (Object)20.0).put((Object)"p1_unique_country_day_2", (Object)20.0).put((Object)"p1_unique_country_day_3", (Object)10.0).put((Object)"sketchEstimatePostAgg", (Object)20.0).put((Object)"sketchIntersectionPostAggEstimate1", (Object)10.0).put((Object)"sketchIntersectionPostAggEstimate2", (Object)5.0).put((Object)"non_existing_col_validation", (Object)0.0).build())).stream().map(row -> ResultRow.fromLegacyRow((Row)row, (GroupByQuery)groupByQuery)).collect(Collectors.toList()), (Object)results);
    }

    @Test
    public void testSketchAggregatorFactoryComparator() {
        Comparator comparator = SketchHolder.COMPARATOR;
        Assert.assertEquals((long)0L, (long)comparator.compare(null, null));
        Union union1 = (Union)SetOperation.builder().setNominalEntries(16).build(Family.UNION);
        union1.update("a");
        union1.update("b");
        CompactSketch sketch1 = union1.getResult();
        Assert.assertEquals((long)-1L, (long)comparator.compare(null, SketchHolder.of((Object)sketch1)));
        Assert.assertEquals((long)1L, (long)comparator.compare(SketchHolder.of((Object)sketch1), null));
        Union union2 = (Union)SetOperation.builder().setNominalEntries(16).build(Family.UNION);
        union2.update("a");
        union2.update("b");
        union2.update("c");
        CompactSketch sketch2 = union2.getResult();
        Assert.assertEquals((long)-1L, (long)comparator.compare(SketchHolder.of((Object)sketch1), SketchHolder.of((Object)sketch2)));
        Assert.assertEquals((long)-1L, (long)comparator.compare(SketchHolder.of((Object)sketch1), SketchHolder.of((Object)union2)));
        Assert.assertEquals((long)1L, (long)comparator.compare(SketchHolder.of((Object)sketch2), SketchHolder.of((Object)sketch1)));
        Assert.assertEquals((long)1L, (long)comparator.compare(SketchHolder.of((Object)sketch2), SketchHolder.of((Object)union1)));
        Assert.assertEquals((long)1L, (long)comparator.compare(SketchHolder.of((Object)union2), SketchHolder.of((Object)union1)));
        Assert.assertEquals((long)1L, (long)comparator.compare(SketchHolder.of((Object)union2), SketchHolder.of((Object)sketch1)));
    }

    @Test
    public void testRelocation() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        SketchHolder sketchHolder = SketchHolder.of((Object)Sketches.updateSketchBuilder().setNominalEntries(16).build());
        UpdateSketch updateSketch = (UpdateSketch)sketchHolder.getSketch();
        updateSketch.update(1L);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"sketch", (Object)sketchHolder)));
        SketchHolder[] holders = (SketchHolder[])this.helper.runRelocateVerificationTest((AggregatorFactory)new SketchMergeAggregatorFactory("sketch", "sketch", Integer.valueOf(16), Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(2)), (ColumnSelectorFactory)columnSelectorFactory, SketchHolder.class);
        Assert.assertEquals((double)holders[0].getEstimate(), (double)holders[1].getEstimate(), (double)0.0);
    }

    @Test
    public void testUpdateUnionWithNullInList() {
        ArrayList<String> value = new ArrayList<String>();
        value.add("foo");
        value.add(null);
        value.add("bar");
        Object[] columnValues = new List[]{value};
        TestObjectColumnSelector selector = new TestObjectColumnSelector(columnValues);
        SketchAggregator agg = new SketchAggregator((BaseObjectColumnValueSelector)selector, 4096);
        agg.aggregate();
        Assert.assertFalse((boolean)agg.isNull());
        Assert.assertNotNull((Object)agg.get());
        Assert.assertTrue((boolean)(agg.get() instanceof SketchHolder));
        Assert.assertEquals((double)2.0, (double)((SketchHolder)agg.get()).getEstimate(), (double)0.0);
        Assert.assertNotNull((Object)((SketchHolder)agg.get()).getSketch());
        Assert.assertEquals((double)2.0, (double)((SketchHolder)agg.get()).getSketch().getEstimate(), (double)0.0);
    }

    private void assertPostAggregatorSerde(PostAggregator agg) throws Exception {
        Assert.assertEquals((Object)agg, (Object)this.helper.getObjectMapper().readValue(this.helper.getObjectMapper().writeValueAsString((Object)agg), PostAggregator.class));
    }

    public static String readFileFromClasspathAsString(String fileName) throws IOException {
        return Files.asCharSource((File)new File(SketchAggregationTest.class.getClassLoader().getResource(fileName).getFile()), (Charset)StandardCharsets.UTF_8).read();
    }
}

