/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class BufferHashGrouperUsingSketchMergeAggregatorFactoryTest {
    private static BufferHashGrouper<Integer> makeGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets) {
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(bufferSize)), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new SketchMergeAggregatorFactory("sketch", "sketch", Integer.valueOf(16), Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(2)), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.75f, initialBuckets, true);
        grouper.init();
        return grouper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrowingBufferGrouper() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        try (BufferHashGrouper<Integer> grouper = BufferHashGrouperUsingSketchMergeAggregatorFactoryTest.makeGrouper(columnSelectorFactory, 100000, 2);){
            int i;
            int expectedMaxSize = 5;
            SketchHolder sketchHolder = SketchHolder.of((Object)Sketches.updateSketchBuilder().setNominalEntries(16).build());
            UpdateSketch updateSketch = (UpdateSketch)sketchHolder.getSketch();
            updateSketch.update(1L);
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"sketch", (Object)sketchHolder)));
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
            }
            updateSketch.update(3L);
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"sketch", (Object)sketchHolder)));
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
            }
            Object[] holders = ((Grouper.Entry)Lists.newArrayList((Iterator)grouper.iterator(true)).get(0)).getValues();
            Assert.assertEquals((double)2.0, (double)((SketchHolder)holders[0]).getEstimate(), (double)0.0);
        }
    }
}

