/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles.sql;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchModule;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToCDFPostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToHistogramPostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToQuantilePostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToQuantilesPostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToRankPostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToStringPostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchApproxQuantileSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchCDFOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchObjectSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchQuantileOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchQuantilesOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchRankOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchSummaryOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchToHistogramOperatorConversion;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DoublesSketchSqlAggregatorTest
extends CalciteTestBase {
    private static final String DATA_SOURCE = "foo";
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private static AuthenticationResult authenticationResult;
    private static final Map<String, Object> QUERY_CONTEXT_DEFAULT;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create();
    private SpecificSegmentsQuerySegmentWalker walker;
    private SqlLifecycleFactory sqlLifecycleFactory;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        DoublesSketchModule.registerSerde();
        for (Module mod : new DoublesSketchModule().getJacksonModules()) {
            CalciteTests.getJsonMapper().registerModule(mod);
            TestHelper.JSON_MAPPER.registerModule(mod);
        }
        QueryableIndex index = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new DoublesSketchAggregatorFactory("qsketch_m1", "m1", Integer.valueOf(128))}).withRollup(false).build()).rows((Iterable)CalciteTests.ROWS1).buildMMappedIndex();
        this.walker = new SpecificSegmentsQuerySegmentWalker(conglomerate).add(DataSegment.builder().dataSource(DATA_SOURCE).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index);
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of((Object)new DoublesSketchApproxQuantileSqlAggregator(), (Object)new DoublesSketchObjectSqlAggregator()), (Set)ImmutableSet.of((Object)new DoublesSketchQuantileOperatorConversion(), (Object)new DoublesSketchQuantilesOperatorConversion(), (Object)new DoublesSketchToHistogramOperatorConversion(), (Object)new DoublesSketchRankOperatorConversion(), (Object)new DoublesSketchCDFOperatorConversion(), (Object)new DoublesSketchSummaryOperatorConversion(), (Object[])new SqlOperatorConversion[0]));
        SchemaPlus rootSchema = CalciteTests.createMockRootSchema((QueryRunnerFactoryConglomerate)conglomerate, (SpecificSegmentsQuerySegmentWalker)this.walker, (PlannerConfig)plannerConfig, (AuthorizerMapper)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        this.sqlLifecycleFactory = CalciteTests.createSqlLifecycleFactory((PlannerFactory)new PlannerFactory(rootSchema, CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, (QueryRunnerFactoryConglomerate)conglomerate), operatorTable, CalciteTests.createExprMacroTable(), plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid"));
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
    }

    @Test
    public void testQuantileOnFloatAndLongs() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\nAPPROX_QUANTILE_DS(m1, 0.01),\nAPPROX_QUANTILE_DS(m1, 0.5, 64),\nAPPROX_QUANTILE_DS(m1, 0.98, 256),\nAPPROX_QUANTILE_DS(m1, 0.99),\nAPPROX_QUANTILE_DS(m1 * 2, 0.97),\nAPPROX_QUANTILE_DS(m1, 0.99) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(m1, 0.999) FILTER(WHERE dim1 <> 'abc'),\nAPPROX_QUANTILE_DS(m1, 0.999) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(cnt, 0.5)\nFROM foo";
        List results = sqlLifecycle.runSimple("SELECT\nAPPROX_QUANTILE_DS(m1, 0.01),\nAPPROX_QUANTILE_DS(m1, 0.5, 64),\nAPPROX_QUANTILE_DS(m1, 0.98, 256),\nAPPROX_QUANTILE_DS(m1, 0.99),\nAPPROX_QUANTILE_DS(m1 * 2, 0.97),\nAPPROX_QUANTILE_DS(m1, 0.99) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(m1, 0.999) FILTER(WHERE dim1 <> 'abc'),\nAPPROX_QUANTILE_DS(m1, 0.999) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(cnt, 0.5)\nFROM foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1.0, 4.0, 6.0, 6.0, 12.0, 6.0, 5.0, 6.0, 1.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "(\"m1\" * 2)", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new DoublesSketchAggregatorFactory("a0:agg", "m1", null), (Object)new DoublesSketchAggregatorFactory("a1:agg", "m1", Integer.valueOf(64)), (Object)new DoublesSketchAggregatorFactory("a2:agg", "m1", Integer.valueOf(256)), (Object)new DoublesSketchAggregatorFactory("a4:agg", "v0", null), (Object)new FilteredAggregatorFactory((AggregatorFactory)new DoublesSketchAggregatorFactory("a5:agg", "m1", null), (DimFilter)new SelectorDimFilter("dim1", "abc", null)), (Object)new FilteredAggregatorFactory((AggregatorFactory)new DoublesSketchAggregatorFactory("a6:agg", "m1", null), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim1", "abc", null))), (Object)new DoublesSketchAggregatorFactory("a8:agg", "cnt", null))).postAggregators(new PostAggregator[]{new DoublesSketchToQuantilePostAggregator("a0", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a0:agg"), (double)0.01f), new DoublesSketchToQuantilePostAggregator("a1", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a1:agg"), 0.5), new DoublesSketchToQuantilePostAggregator("a2", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a2:agg"), (double)0.98f), new DoublesSketchToQuantilePostAggregator("a3", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a0:agg"), (double)0.99f), new DoublesSketchToQuantilePostAggregator("a4", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a4:agg"), (double)0.97f), new DoublesSketchToQuantilePostAggregator("a5", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a5:agg"), (double)0.99f), new DoublesSketchToQuantilePostAggregator("a6", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a6:agg"), (double)0.999f), new DoublesSketchToQuantilePostAggregator("a7", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a5:agg"), (double)0.999f), new DoublesSketchToQuantilePostAggregator("a8", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a8:agg"), 0.5)}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testQuantileOnComplexColumn() throws Exception {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\nAPPROX_QUANTILE_DS(qsketch_m1, 0.01),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.5, 64),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.98, 256),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.99),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.99) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.999) FILTER(WHERE dim1 <> 'abc'),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.999) FILTER(WHERE dim1 = 'abc')\nFROM foo";
        List results = lifecycle.runSimple("SELECT\nAPPROX_QUANTILE_DS(qsketch_m1, 0.01),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.5, 64),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.98, 256),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.99),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.99) FILTER(WHERE dim1 = 'abc'),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.999) FILTER(WHERE dim1 <> 'abc'),\nAPPROX_QUANTILE_DS(qsketch_m1, 0.999) FILTER(WHERE dim1 = 'abc')\nFROM foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1.0, 4.0, 6.0, 6.0, 6.0, 5.0, 6.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new DoublesSketchAggregatorFactory("a0:agg", "qsketch_m1", null), (Object)new DoublesSketchAggregatorFactory("a1:agg", "qsketch_m1", Integer.valueOf(64)), (Object)new DoublesSketchAggregatorFactory("a2:agg", "qsketch_m1", Integer.valueOf(256)), (Object)new FilteredAggregatorFactory((AggregatorFactory)new DoublesSketchAggregatorFactory("a4:agg", "qsketch_m1", null), (DimFilter)new SelectorDimFilter("dim1", "abc", null)), (Object)new FilteredAggregatorFactory((AggregatorFactory)new DoublesSketchAggregatorFactory("a5:agg", "qsketch_m1", null), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim1", "abc", null))))).postAggregators(new PostAggregator[]{new DoublesSketchToQuantilePostAggregator("a0", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a0:agg"), (double)0.01f), new DoublesSketchToQuantilePostAggregator("a1", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a1:agg"), 0.5), new DoublesSketchToQuantilePostAggregator("a2", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a2:agg"), (double)0.98f), new DoublesSketchToQuantilePostAggregator("a3", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a0:agg"), (double)0.99f), new DoublesSketchToQuantilePostAggregator("a4", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a4:agg"), (double)0.99f), new DoublesSketchToQuantilePostAggregator("a5", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a5:agg"), (double)0.999f), new DoublesSketchToQuantilePostAggregator("a6", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a4:agg"), (double)0.999f)}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testQuantileOnInnerQuery() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT AVG(x), APPROX_QUANTILE_DS(x, 0.98)\nFROM (SELECT dim2, SUM(m1) AS x FROM foo GROUP BY dim2)";
        List results = sqlLifecycle.runSimple("SELECT AVG(x), APPROX_QUANTILE_DS(x, 0.98)\nFROM (SELECT dim2, SUM(m1) AS x FROM foo GROUP BY dim2)", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{7.0, 11.0}) : ImmutableList.of((Object)new Object[]{5.25, 8.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")}).setAggregatorSpecs((List)ImmutableList.of((Object)new DoubleSumAggregatorFactory("a0", "m1"))).setContext((Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy")).build())).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0:sum", "a0"), new CountAggregatorFactory("_a0:count"), new DoublesSketchAggregatorFactory("_a1:agg", "a0", null)}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a0:sum"), (Object)new FieldAccessPostAggregator(null, "_a0:count"))), (Object)new DoublesSketchToQuantilePostAggregator("_a1", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("_a1:agg"), (double)0.98f))).setContext((Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testQuantileOnInnerQuantileQuery() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT dim1, APPROX_QUANTILE_DS(x, 0.5)\nFROM (SELECT dim1, dim2, APPROX_QUANTILE_DS(m1, 0.5) AS x FROM foo GROUP BY dim1, dim2) GROUP BY dim1";
        List results = sqlLifecycle.runSimple("SELECT dim1, APPROX_QUANTILE_DS(x, 0.5)\nFROM (SELECT dim1, dim2, APPROX_QUANTILE_DS(m1, 0.5) AS x FROM foo GROUP BY dim1, dim2) GROUP BY dim1", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Object[]{"", 1.0});
        builder.add((Object)new Object[]{"1", 4.0});
        builder.add((Object)new Object[]{"10.1", 2.0});
        builder.add((Object)new Object[]{"2", 3.0});
        builder.add((Object)new Object[]{"abc", 6.0});
        builder.add((Object)new Object[]{"def", 5.0});
        ImmutableList expectedResults = builder.build();
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource(DATA_SOURCE).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs((List)ImmutableList.of((Object)new DoublesSketchAggregatorFactory("a0:agg", "m1", Integer.valueOf(128)))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new DoublesSketchToQuantilePostAggregator("a0", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a0:agg"), 0.5))).setContext((Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy")).build())).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ValueType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new DoublesSketchAggregatorFactory("_a0:agg", "a0", Integer.valueOf(128))}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new DoublesSketchToQuantilePostAggregator("_a0", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("_a0:agg"), 0.5))).setContext((Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testDoublesSketchPostAggs() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  SUM(cnt),\n  APPROX_QUANTILE_DS(cnt, 0.5) + 1,\n  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt), 0.5) + 1000,\n  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt + 123), 0.5) + 1000,\n  ABS(DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt), 0.5)),\n  DS_GET_QUANTILES(DS_QUANTILES_SKETCH(cnt), 0.5, 0.8),\n  DS_HISTOGRAM(DS_QUANTILES_SKETCH(cnt), 0.2, 0.6),\n  DS_RANK(DS_QUANTILES_SKETCH(cnt), 3),\n  DS_CDF(DS_QUANTILES_SKETCH(cnt), 0.2, 0.6),\n  DS_QUANTILE_SUMMARY(DS_QUANTILES_SKETCH(cnt))\nFROM foo";
        List results = sqlLifecycle.runSimple("SELECT\n  SUM(cnt),\n  APPROX_QUANTILE_DS(cnt, 0.5) + 1,\n  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt), 0.5) + 1000,\n  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt + 123), 0.5) + 1000,\n  ABS(DS_GET_QUANTILE(DS_QUANTILES_SKETCH(cnt), 0.5)),\n  DS_GET_QUANTILES(DS_QUANTILES_SKETCH(cnt), 0.5, 0.8),\n  DS_HISTOGRAM(DS_QUANTILES_SKETCH(cnt), 0.2, 0.6),\n  DS_RANK(DS_QUANTILES_SKETCH(cnt), 3),\n  DS_CDF(DS_QUANTILES_SKETCH(cnt), 0.2, 0.6),\n  DS_QUANTILE_SUMMARY(DS_QUANTILES_SKETCH(cnt))\nFROM foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{6L, 2.0, 1001.0, 1124.0, 1.0, "[1.0,1.0]", "[0.0,0.0,6.0]", 1.0, "[0.0,0.0,1.0]", "\n### Quantiles HeapUpdateDoublesSketch SUMMARY: \n   Empty                        : false\n   Direct, Capacity bytes       : false, \n   Estimation Mode              : false\n   K                            : 128\n   N                            : 6\n   Levels (Needed, Total, Valid): 0, 0, 0\n   Level Bit Pattern            : 0\n   BaseBufferCount              : 6\n   Combined Buffer Capacity     : 8\n   Retained Items               : 6\n   Compact Storage Bytes        : 80\n   Updatable Storage Bytes      : 96\n   Normalized Rank Error        : 1.406%\n   Normalized Rank Error (PMF)  : 1.711%\n   Min Value                    : 1.000000e+00\n   Max Value                    : 1.000000e+00\n### END SKETCH SUMMARY\n"});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "(\"cnt\" + 123)", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a0", "cnt"), (Object)new DoublesSketchAggregatorFactory("a1:agg", "cnt", Integer.valueOf(128)), (Object)new DoublesSketchAggregatorFactory("a2:agg", "cnt", Integer.valueOf(128)), (Object)new DoublesSketchAggregatorFactory("a3:agg", "v0", Integer.valueOf(128)))).postAggregators(new PostAggregator[]{new DoublesSketchToQuantilePostAggregator("a1", DoublesSketchSqlAggregatorTest.makeFieldAccessPostAgg("a1:agg"), 0.5), new ExpressionPostAggregator("p0", "(\"a1\" + 1)", null, TestExprMacroTable.INSTANCE), new DoublesSketchToQuantilePostAggregator("p2", (PostAggregator)new FieldAccessPostAggregator("p1", "a2:agg"), 0.5), new ExpressionPostAggregator("p3", "(p2 + 1000)", null, TestExprMacroTable.INSTANCE), new DoublesSketchToQuantilePostAggregator("p5", (PostAggregator)new FieldAccessPostAggregator("p4", "a3:agg"), 0.5), new ExpressionPostAggregator("p6", "(p5 + 1000)", null, TestExprMacroTable.INSTANCE), new DoublesSketchToQuantilePostAggregator("p8", (PostAggregator)new FieldAccessPostAggregator("p7", "a2:agg"), 0.5), new ExpressionPostAggregator("p9", "abs(p8)", null, TestExprMacroTable.INSTANCE), new DoublesSketchToQuantilesPostAggregator("p11", (PostAggregator)new FieldAccessPostAggregator("p10", "a2:agg"), new double[]{0.5, 0.8}), new DoublesSketchToHistogramPostAggregator("p13", (PostAggregator)new FieldAccessPostAggregator("p12", "a2:agg"), new double[]{0.2, 0.6}, null), new DoublesSketchToRankPostAggregator("p15", (PostAggregator)new FieldAccessPostAggregator("p14", "a2:agg"), 3.0), new DoublesSketchToCDFPostAggregator("p17", (PostAggregator)new FieldAccessPostAggregator("p16", "a2:agg"), new double[]{0.2, 0.6}), new DoublesSketchToStringPostAggregator("p19", (PostAggregator)new FieldAccessPostAggregator("p18", "a2:agg"))}).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    @Test
    public void testDoublesSketchPostAggsPostSort() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT DS_QUANTILES_SKETCH(m1) as y FROM druid.foo ORDER BY  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(m1), 0.5) DESC LIMIT 10";
        String sql2 = StringUtils.format((String)"SELECT DS_GET_QUANTILE(y, 0.5), DS_GET_QUANTILE(y, 0.98) from (%s)", (Object[])new Object[]{"SELECT DS_QUANTILES_SKETCH(m1) as y FROM druid.foo ORDER BY  DS_GET_QUANTILE(DS_QUANTILES_SKETCH(m1), 0.5) DESC LIMIT 10"});
        List results = sqlLifecycle.runSimple(sql2, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{4.0, 6.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new DoublesSketchAggregatorFactory("a0:agg", "m1", Integer.valueOf(128)))).postAggregators((List)ImmutableList.of((Object)new FieldAccessPostAggregator("p0", "a0:agg"), (Object)new DoublesSketchToQuantilePostAggregator("p2", (PostAggregator)new FieldAccessPostAggregator("p1", "a0:agg"), 0.5), (Object)new DoublesSketchToQuantilePostAggregator("s1", (PostAggregator)new FieldAccessPostAggregator("s0", "p0"), 0.5), (Object)new DoublesSketchToQuantilePostAggregator("s3", (PostAggregator)new FieldAccessPostAggregator("s2", "p0"), (double)0.98f))).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    private static PostAggregator makeFieldAccessPostAgg(String name) {
        return new FieldAccessPostAggregator(name, name);
    }

    static {
        authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
        QUERY_CONTEXT_DEFAULT = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy");
    }
}

