/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.druid.java.util.common.StringUtils;

public class GenerateTestData {
    public static void main(String[] args) throws Exception {
        Path buildPath = FileSystems.getDefault().getPath("doubles_build_data.tsv", new String[0]);
        Path sketchPath = FileSystems.getDefault().getPath("doubles_sketch_data.tsv", new String[0]);
        BufferedWriter buildData = Files.newBufferedWriter(buildPath, StandardCharsets.UTF_8, new OpenOption[0]);
        BufferedWriter sketchData = Files.newBufferedWriter(sketchPath, StandardCharsets.UTF_8, new OpenOption[0]);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int sequenceNumber = 0;
        for (int i = 0; i < 20; ++i) {
            int product = ((Random)rand).nextInt(10);
            UpdateDoublesSketch sketch = DoublesSketch.builder().build();
            for (int j = 0; j < 20; ++j) {
                double value = ((Random)rand).nextDouble();
                buildData.write("2016010101");
                buildData.write(9);
                buildData.write(Integer.toString(sequenceNumber));
                buildData.write(9);
                buildData.write(Integer.toString(product));
                buildData.write(9);
                buildData.write(Double.toString(value));
                buildData.newLine();
                sketch.update(value);
                ++sequenceNumber;
            }
            sketchData.write("2016010101");
            sketchData.write(9);
            sketchData.write(Integer.toString(product));
            sketchData.write(9);
            sketchData.write(StringUtils.encodeBase64String((byte[])sketch.toByteArray(true)));
            sketchData.newLine();
        }
        buildData.close();
        sketchData.close();
    }
}

