/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.core.JsonProcessingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToStringPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DoublesSketchToStringPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws JsonProcessingException {
        DoublesSketchToStringPostAggregator there = new DoublesSketchToStringPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        DoublesSketchToStringPostAggregator andBackAgain = (DoublesSketchToStringPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), DoublesSketchToStringPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        DoublesSketchToStringPostAggregator postAgg = new DoublesSketchToStringPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"));
        Assert.assertEquals((Object)"DoublesSketchToStringPostAggregator{name='post', field=FieldAccessPostAggregator{name='field1', fieldName='sketch'}}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Comparing sketch summaries is not supported");
        DoublesSketchToStringPostAggregator postAgg = new DoublesSketchToStringPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"));
        postAgg.getComparator();
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DoublesSketchToStringPostAggregator.class).withNonnullFields(new String[]{"name", "field"}).usingGetClass().verify();
    }
}

