/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToRankPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class DoublesSketchToRankPostAggregatorTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        DoublesSketchToRankPostAggregator there = new DoublesSketchToRankPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), 0.0);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        DoublesSketchToRankPostAggregator andBackAgain = (DoublesSketchToRankPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), DoublesSketchToRankPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        DoublesSketchToRankPostAggregator postAgg = new DoublesSketchToRankPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), 0.0);
        Assert.assertEquals((Object)"DoublesSketchToRankPostAggregator{name='post', field=FieldAccessPostAggregator{name='field1', fieldName='sketch'}, value=0.0}", (Object)postAgg.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DoublesSketchToRankPostAggregator.class).withNonnullFields(new String[]{"name", "field", "value"}).usingGetClass().verify();
    }

    @Test
    public void emptySketch() {
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(null);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToRankPostAggregator postAgg = new DoublesSketchToRankPostAggregator("rank", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), 0.0);
        double rank = (Double)postAgg.compute(fields);
        Assert.assertTrue((boolean)Double.isNaN(rank));
    }

    @Test
    public void normalCase() {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(values);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        for (int i = 0; i < values.length; ++i) {
            agg.aggregate();
            selector.increment();
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToRankPostAggregator postAgg = new DoublesSketchToRankPostAggregator("rank", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), 4.0);
        double rank = (Double)postAgg.compute(fields);
        Assert.assertEquals((double)0.5, (double)rank, (double)0.0);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new DoublesSketchAggregatorFactory("sketch", "col", Integer.valueOf(8))}).postAggregators(new PostAggregator[]{new DoublesSketchToRankPostAggregator("a", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), 4.0)}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("sketch", null).add("a", ValueType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

