/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToQuantilesPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DoublesSketchToQuantilesPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws JsonProcessingException {
        DoublesSketchToQuantilesPostAggregator there = new DoublesSketchToQuantilesPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.0, 0.5, 1.0});
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        DoublesSketchToQuantilesPostAggregator andBackAgain = (DoublesSketchToQuantilesPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), DoublesSketchToQuantilesPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        DoublesSketchToQuantilesPostAggregator postAgg = new DoublesSketchToQuantilesPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.0, 0.5, 1.0});
        Assert.assertEquals((Object)"DoublesSketchToQuantilesPostAggregator{name='post', field=FieldAccessPostAggregator{name='field1', fieldName='sketch'}, fractions=[0.0, 0.5, 1.0]}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Comparing arrays of quantiles is not supported");
        DoublesSketchToQuantilesPostAggregator postAgg = new DoublesSketchToQuantilesPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.0, 0.5, 1.0});
        postAgg.getComparator();
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DoublesSketchToQuantilesPostAggregator.class).withNonnullFields(new String[]{"name", "field", "fractions"}).usingGetClass().verify();
    }

    @Test
    public void emptySketch() {
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(null);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToQuantilesPostAggregator postAgg = new DoublesSketchToQuantilesPostAggregator("quantiles", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{0.0, 0.5, 1.0});
        double[] quantiles = (double[])postAgg.compute(fields);
        Assert.assertNotNull((Object)quantiles);
        Assert.assertEquals((long)3L, (long)quantiles.length);
        Assert.assertTrue((boolean)Double.isNaN(quantiles[0]));
        Assert.assertTrue((boolean)Double.isNaN(quantiles[1]));
        Assert.assertTrue((boolean)Double.isNaN(quantiles[2]));
    }

    @Test
    public void normalCase() {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(values);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        for (int i = 0; i < values.length; ++i) {
            agg.aggregate();
            selector.increment();
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToQuantilesPostAggregator postAgg = new DoublesSketchToQuantilesPostAggregator("quantiles", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{0.0, 0.5, 1.0});
        double[] quantiles = (double[])postAgg.compute(fields);
        Assert.assertNotNull((Object)quantiles);
        Assert.assertEquals((long)3L, (long)quantiles.length);
        Assert.assertEquals((double)1.0, (double)quantiles[0], (double)0.0);
        Assert.assertEquals((double)3.0, (double)quantiles[1], (double)0.0);
        Assert.assertEquals((double)5.0, (double)quantiles[2], (double)0.0);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new DoublesSketchAggregatorFactory("sketch", "col", Integer.valueOf(8))}).postAggregators(new PostAggregator[]{new DoublesSketchToQuantilesPostAggregator("a", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{0.0, 0.5, 1.0})}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("sketch", null).add("a", ValueType.DOUBLE_ARRAY).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

