/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToCDFPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DoublesSketchToCDFPostAggregatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws JsonProcessingException {
        DoublesSketchToCDFPostAggregator there = new DoublesSketchToCDFPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.25, 0.75});
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        DoublesSketchToCDFPostAggregator andBackAgain = (DoublesSketchToCDFPostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), DoublesSketchToCDFPostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        DoublesSketchToCDFPostAggregator postAgg = new DoublesSketchToCDFPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.25, 0.75});
        Assert.assertEquals((Object)"DoublesSketchToCDFPostAggregator{name='post', field=FieldAccessPostAggregator{name='field1', fieldName='sketch'}, splitPoints=[0.25, 0.75]}", (Object)postAgg.toString());
    }

    @Test
    public void testComparator() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Comparing histograms is not supported");
        DoublesSketchToCDFPostAggregator postAgg = new DoublesSketchToCDFPostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), new double[]{0.25, 0.75});
        postAgg.getComparator();
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DoublesSketchToCDFPostAggregator.class).withNonnullFields(new String[]{"name", "field", "splitPoints"}).usingGetClass().verify();
    }

    @Test
    public void emptySketch() {
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(null);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToCDFPostAggregator postAgg = new DoublesSketchToCDFPostAggregator("cdf", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{4.0});
        double[] histogram = (double[])postAgg.compute(fields);
        Assert.assertNotNull((Object)histogram);
        Assert.assertEquals((long)2L, (long)histogram.length);
        Assert.assertTrue((boolean)Double.isNaN(histogram[0]));
        Assert.assertTrue((boolean)Double.isNaN(histogram[1]));
    }

    @Test
    public void normalCase() {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        TestDoubleColumnSelectorImpl selector = new TestDoubleColumnSelectorImpl(values);
        DoublesSketchBuildAggregator agg = new DoublesSketchBuildAggregator((ColumnValueSelector)selector, 8);
        for (int i = 0; i < values.length; ++i) {
            agg.aggregate();
            selector.increment();
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("sketch", agg.get());
        DoublesSketchToCDFPostAggregator postAgg = new DoublesSketchToCDFPostAggregator("cdf", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{4.0});
        double[] cdf = (double[])postAgg.compute(fields);
        Assert.assertNotNull((Object)cdf);
        Assert.assertEquals((long)2L, (long)cdf.length);
        Assert.assertEquals((double)0.5, (double)cdf[0], (double)0.0);
        Assert.assertEquals((double)1.0, (double)cdf[1], (double)0.0);
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new DoublesSketchAggregatorFactory("sketch", "col", Integer.valueOf(8))}).postAggregators(new PostAggregator[]{new DoublesSketchToCDFPostAggregator("a", (PostAggregator)new FieldAccessPostAggregator("field", "sketch"), new double[]{4.0})}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("sketch", null).add("a", ValueType.DOUBLE_ARRAY).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

