/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.junit.Assert;
import org.junit.Test;

public class DoublesSketchComplexMetricSerdeTest {
    @Test
    public void testExtractorOnEmptyString() {
        DoublesSketchComplexMetricSerde serde = new DoublesSketchComplexMetricSerde();
        ComplexMetricExtractor extractor = serde.getExtractor();
        DoublesSketch sketch = (DoublesSketch)extractor.extractValue((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"foo", (Object)"")), "foo");
        Assert.assertEquals((long)0L, (long)sketch.getRetainedItems());
    }

    @Test
    public void testExtractorOnPositiveNumber() {
        DoublesSketchComplexMetricSerde serde = new DoublesSketchComplexMetricSerde();
        ComplexMetricExtractor extractor = serde.getExtractor();
        DoublesSketch sketch = (DoublesSketch)extractor.extractValue((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"foo", (Object)"777")), "foo");
        Assert.assertEquals((long)1L, (long)sketch.getRetainedItems());
        Assert.assertEquals((double)777.0, (double)sketch.getMaxValue(), (double)0.01);
    }

    @Test
    public void testExtractorOnNegativeNumber() {
        DoublesSketchComplexMetricSerde serde = new DoublesSketchComplexMetricSerde();
        ComplexMetricExtractor extractor = serde.getExtractor();
        DoublesSketch sketch = (DoublesSketch)extractor.extractValue((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"foo", (Object)"-133")), "foo");
        Assert.assertEquals((long)1L, (long)sketch.getRetainedItems());
        Assert.assertEquals((double)-133.0, (double)sketch.getMaxValue(), (double)0.01);
    }

    @Test
    public void testExtractorOnDecimalNumber() {
        DoublesSketchComplexMetricSerde serde = new DoublesSketchComplexMetricSerde();
        ComplexMetricExtractor extractor = serde.getExtractor();
        DoublesSketch sketch = (DoublesSketch)extractor.extractValue((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"foo", (Object)"3.1")), "foo");
        Assert.assertEquals((long)1L, (long)sketch.getRetainedItems());
        Assert.assertEquals((double)3.1, (double)sketch.getMaxValue(), (double)0.01);
    }

    @Test
    public void testExtractorOnLeadingDecimalNumber() {
        DoublesSketchComplexMetricSerde serde = new DoublesSketchComplexMetricSerde();
        ComplexMetricExtractor extractor = serde.getExtractor();
        DoublesSketch sketch = (DoublesSketch)extractor.extractValue((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"foo", (Object)".1")), "foo");
        Assert.assertEquals((long)1L, (long)sketch.getRetainedItems());
        Assert.assertEquals((double)0.1, (double)sketch.getMaxValue(), (double)0.01);
    }
}

