/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchModule;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DoublesSketchAggregatorTest
extends InitializedNullHandlingTest {
    private final AggregationTestHelper helper;
    private final AggregationTestHelper timeSeriesHelper;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public DoublesSketchAggregatorTest(GroupByQueryConfig config) {
        DoublesSketchModule.registerSerde();
        DoublesSketchModule module = new DoublesSketchModule();
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)module.getJacksonModules(), (GroupByQueryConfig)config, (TemporaryFolder)this.tempFolder);
        this.timeSeriesHelper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper((List)module.getJacksonModules(), (TemporaryFolder)this.tempFolder);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @After
    public void teardown() throws IOException {
        this.helper.close();
    }

    @Test
    public void serializeDeserializeFactoryWithFieldName() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        new DoublesSketchModule().getJacksonModules().forEach(arg_0 -> ((ObjectMapper)objectMapper).registerModule(arg_0));
        DoublesSketchAggregatorFactory factory = new DoublesSketchAggregatorFactory("name", "filedName", Integer.valueOf(128));
        AggregatorFactory other = (AggregatorFactory)objectMapper.readValue(objectMapper.writeValueAsString((Object)factory), AggregatorFactory.class);
        Assert.assertEquals((Object)factory, (Object)other);
    }

    @Test
    public void serializeDeserializeCombiningFactoryWithFieldName() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        new DoublesSketchModule().getJacksonModules().forEach(arg_0 -> ((ObjectMapper)objectMapper).registerModule(arg_0));
        DoublesSketchMergeAggregatorFactory factory = new DoublesSketchMergeAggregatorFactory("name", Integer.valueOf(128));
        AggregatorFactory other = (AggregatorFactory)objectMapper.readValue(objectMapper.writeValueAsString((Object)factory), AggregatorFactory.class);
        Assert.assertEquals((Object)factory, (Object)other);
    }

    @Test
    public void ingestingSketches() throws Exception {
        double[] histogram;
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("quantiles/doubles_sketch_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"product\", \"sketch\"]", "  }", "}"), String.join((CharSequence)"\n", "[", "  {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"k\": 128},", "  {\"type\": \"quantilesDoublesSketch\", \"name\": \"non_existent_sketch\", \"fieldName\": \"non_existent_sketch\", \"k\": 128}", "]"), 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"k\": 128},", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"non_existent_sketch\", \"fieldName\": \"non_existent_sketch\", \"k\": 128}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantiles\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogram\", \"splitPoints\": [0.25, 0.5, 0.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}}", "  ],", "  \"intervals\": [\"2016-01-01T00:00:00.000Z/2016-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Object nonExistentSketchObject = row.get(1);
        Assert.assertTrue((boolean)(nonExistentSketchObject instanceof Long));
        long nonExistentSketchValue = (Long)nonExistentSketchObject;
        Assert.assertEquals((long)0L, (long)nonExistentSketchValue);
        Object sketchObject = row.get(0);
        Assert.assertTrue((boolean)(sketchObject instanceof Long));
        long sketchValue = (Long)sketchObject;
        Assert.assertEquals((long)400L, (long)sketchValue);
        Object quantilesObject = row.get(2);
        Assert.assertTrue((boolean)(quantilesObject instanceof double[]));
        double[] quantiles = (double[])quantilesObject;
        Assert.assertEquals((double)0.0, (double)quantiles[0], (double)0.05);
        Assert.assertEquals((double)0.5, (double)quantiles[1], (double)0.05);
        Assert.assertEquals((double)1.0, (double)quantiles[2], (double)0.05);
        Object histogramObject = row.get(3);
        Assert.assertTrue((boolean)(histogramObject instanceof double[]));
        for (double bin : histogram = (double[])histogramObject) {
            Assert.assertEquals((double)100.0, (double)bin, (double)20.0);
        }
    }

    @Test
    public void buildingSketchesAtIngestionTime() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("quantiles/doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"product\"],", "      \"dimensionExclusions\": [ \"sequenceNumber\"],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"sequenceNumber\", \"product\", \"value\", \"valueWithNulls\"]", "  }", "}"), "[{\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"value\", \"k\": 128},{\"type\": \"quantilesDoublesSketch\", \"name\": \"sketchWithNulls\", \"fieldName\": \"valueWithNulls\", \"k\": 128}]", 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"sketch\", \"k\": 128},", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketchWithNulls\", \"fieldName\": \"sketchWithNulls\", \"k\": 128},", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"non_existent_sketch\", \"fieldName\": \"non_existent_sketch\", \"k\": 128}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantiles\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogram\", \"splitPoints\": [0.25, 0.5, 0.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantilesWithNulls\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchWithNulls\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogramWithNulls\", \"splitPoints\": [6.25, 7.5, 8.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchWithNulls\"}}", "  ],", "  \"intervals\": [\"2016-01-01T00:00:00.000Z/2016-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Object sketchObject = row.get(0);
        Assert.assertTrue((boolean)(sketchObject instanceof Long));
        long sketchValue = (Long)sketchObject;
        Assert.assertEquals((long)400L, (long)sketchValue);
        Object sketchObjectWithNulls = row.get(1);
        Assert.assertTrue((boolean)(sketchObjectWithNulls instanceof Long));
        long sketchValueWithNulls = (Long)sketchObjectWithNulls;
        Assert.assertEquals((long)377L, (long)sketchValueWithNulls);
        Object quantilesObject = row.get(3);
        Assert.assertTrue((boolean)(quantilesObject instanceof double[]));
        double[] quantiles = (double[])quantilesObject;
        Assert.assertEquals((double)0.0, (double)quantiles[0], (double)0.05);
        Assert.assertEquals((double)0.5, (double)quantiles[1], (double)0.05);
        Assert.assertEquals((double)1.0, (double)quantiles[2], (double)0.05);
        Object histogramObject = row.get(4);
        Assert.assertTrue((boolean)(histogramObject instanceof double[]));
        double[] histogram = (double[])histogramObject;
        Assert.assertEquals((long)4L, (long)histogram.length);
        for (double bin : histogram) {
            Assert.assertEquals((double)100.0, (double)bin, (double)20.0);
        }
        Object quantilesObjectWithNulls = row.get(5);
        Assert.assertTrue((boolean)(quantilesObjectWithNulls instanceof double[]));
        double[] quantilesWithNulls = (double[])quantilesObjectWithNulls;
        Assert.assertEquals((double)5.0, (double)quantilesWithNulls[0], (double)0.05);
        Assert.assertEquals((double)7.55, (double)quantilesWithNulls[1], (double)0.05);
        Assert.assertEquals((double)10.0, (double)quantilesWithNulls[2], (double)0.05);
        Object histogramObjectWithNulls = row.get(6);
        Assert.assertTrue((boolean)(histogramObjectWithNulls instanceof double[]));
        double[] histogramWithNulls = (double[])histogramObjectWithNulls;
        Assert.assertEquals((long)4L, (long)histogramWithNulls.length);
        for (double bin : histogramWithNulls) {
            Assert.assertEquals((double)100.0, (double)bin, (double)50.0);
        }
    }

    @Test
    public void buildingSketchesAtQueryTime() throws Exception {
        double[] histogramWithNulls;
        double[] histogram;
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("quantiles/doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"sequenceNumber\", \"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"sequenceNumber\", \"product\", \"value\", \"valueWithNulls\"]", "  }", "}"), "[{\"type\": \"doubleSum\", \"name\": \"value\", \"fieldName\": \"value\"},{\"type\": \"doubleSum\", \"name\": \"valueWithNulls\", \"fieldName\": \"valueWithNulls\"}]", 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"value\", \"k\": 128},", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketchWithNulls\", \"fieldName\": \"valueWithNulls\", \"k\": 128}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"quantilesDoublesSketchToQuantile\", \"name\": \"quantile\", \"fraction\": 0.5, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantiles\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogram\", \"splitPoints\": [0.25, 0.5, 0.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantile\", \"name\": \"quantileWithNulls\", \"fraction\": 0.5, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchWithNulls\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantilesWithNulls\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchWithNulls\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogramWithNulls\", \"splitPoints\": [6.25, 7.5, 8.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketchWithNulls\"}}", "  ],", "  \"intervals\": [\"2016-01-01T00:00:00.000Z/2016-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Object sketchObject = row.get(0);
        Assert.assertTrue((boolean)(sketchObject instanceof Long));
        long sketchValue = (Long)sketchObject;
        Assert.assertEquals((long)400L, (long)sketchValue);
        Object sketchObjectWithNulls = row.get(1);
        Assert.assertTrue((boolean)(sketchObjectWithNulls instanceof Long));
        long sketchValueWithNulls = (Long)sketchObjectWithNulls;
        Assert.assertEquals((long)(NullHandling.replaceWithDefault() ? 400L : 377L), (long)sketchValueWithNulls);
        Object quantileObject = row.get(2);
        Assert.assertTrue((boolean)(quantileObject instanceof Double));
        Assert.assertEquals((double)0.5, (double)((Double)quantileObject), (double)0.05);
        Object quantilesObject = row.get(3);
        Assert.assertTrue((boolean)(quantilesObject instanceof double[]));
        double[] quantiles = (double[])quantilesObject;
        Assert.assertEquals((double)0.0, (double)quantiles[0], (double)0.05);
        Assert.assertEquals((double)0.5, (double)quantiles[1], (double)0.05);
        Assert.assertEquals((double)1.0, (double)quantiles[2], (double)0.05);
        Object histogramObject = row.get(4);
        Assert.assertTrue((boolean)(histogramObject instanceof double[]));
        for (double bin : histogram = (double[])histogramObject) {
            Assert.assertEquals((double)100.0, (double)bin, (double)20.0);
        }
        Object quantileObjectWithNulls = row.get(5);
        Assert.assertTrue((boolean)(quantileObjectWithNulls instanceof Double));
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.4 : 7.5), (double)((Double)quantileObjectWithNulls), (double)0.1);
        Object quantilesObjectWithNulls = row.get(6);
        Assert.assertTrue((boolean)(quantilesObjectWithNulls instanceof double[]));
        double[] quantilesWithNulls = (double[])quantilesObjectWithNulls;
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 0.0 : 5.0), (double)quantilesWithNulls[0], (double)0.05);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.4 : 7.5), (double)quantilesWithNulls[1], (double)0.1);
        Assert.assertEquals((double)10.0, (double)quantilesWithNulls[2], (double)0.05);
        Object histogramObjectWithNulls = row.get(7);
        Assert.assertTrue((boolean)(histogramObjectWithNulls instanceof double[]));
        for (double bin : histogramWithNulls = (double[])histogramObjectWithNulls) {
            Assert.assertEquals((double)100.0, (double)bin, (double)80.0);
        }
    }

    @Test
    public void queryingDataWithFieldNameValueAsFloatInsteadOfSketch() throws Exception {
        double[] histogram;
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("quantiles/doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"sequenceNumber\", \"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"sequenceNumber\", \"product\", \"value\"]", "  }", "}"), "[{\"type\": \"doubleSum\", \"name\": \"value\", \"fieldName\": \"value\"}]", 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"groupBy\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"dimensions\": [],", "  \"aggregations\": [", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"value\", \"k\": 128}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"quantilesDoublesSketchToQuantile\", \"name\": \"quantile\", \"fraction\": 0.5, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantiles\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogram\", \"splitPoints\": [0.25, 0.5, 0.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}}", "  ],", "  \"intervals\": [\"2016-01-01T00:00:00.000Z/2016-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Object sketchObject = row.get(0);
        Assert.assertTrue((boolean)(sketchObject instanceof Long));
        long sketchValue = (Long)sketchObject;
        Assert.assertEquals((long)400L, (long)sketchValue);
        Object quantileObject = row.get(1);
        Assert.assertTrue((boolean)(quantileObject instanceof Double));
        Assert.assertEquals((double)0.5, (double)((Double)quantileObject), (double)0.05);
        Object quantilesObject = row.get(2);
        Assert.assertTrue((boolean)(quantilesObject instanceof double[]));
        double[] quantiles = (double[])quantilesObject;
        Assert.assertEquals((double)0.0, (double)quantiles[0], (double)0.05);
        Assert.assertEquals((double)0.5, (double)quantiles[1], (double)0.05);
        Assert.assertEquals((double)1.0, (double)quantiles[2], (double)0.05);
        Object histogramObject = row.get(3);
        Assert.assertTrue((boolean)(histogramObject instanceof double[]));
        for (double bin : histogram = (double[])histogramObject) {
            Assert.assertEquals((double)100.0, (double)bin, (double)20.0);
        }
    }

    @Test
    public void timeSeriesQueryInputAsFloat() throws Exception {
        Sequence seq = this.timeSeriesHelper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("quantiles/doubles_build_data.tsv").getFile()), String.join((CharSequence)"\n", "{", "  \"type\": \"string\",", "  \"parseSpec\": {", "    \"format\": \"tsv\",", "    \"timestampSpec\": {\"column\": \"timestamp\", \"format\": \"yyyyMMddHH\"},", "    \"dimensionsSpec\": {", "      \"dimensions\": [\"sequenceNumber\", \"product\"],", "      \"dimensionExclusions\": [],", "      \"spatialDimensions\": []", "    },", "    \"columns\": [\"timestamp\", \"sequenceNumber\", \"product\", \"value\"]", "  }", "}"), "[{\"type\": \"doubleSum\", \"name\": \"value\", \"fieldName\": \"value\"}]", 0L, Granularities.NONE, 10, String.join((CharSequence)"\n", "{", "  \"queryType\": \"timeseries\",", "  \"dataSource\": \"test_datasource\",", "  \"granularity\": \"ALL\",", "  \"aggregations\": [", "    {\"type\": \"quantilesDoublesSketch\", \"name\": \"sketch\", \"fieldName\": \"value\", \"k\": 128}", "  ],", "  \"postAggregations\": [", "    {\"type\": \"quantilesDoublesSketchToQuantile\", \"name\": \"quantile1\", \"fraction\": 0.5, \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToQuantiles\", \"name\": \"quantiles1\", \"fractions\": [0, 0.5, 1], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}},", "    {\"type\": \"quantilesDoublesSketchToHistogram\", \"name\": \"histogram1\", \"splitPoints\": [0.25, 0.5, 0.75], \"field\": {\"type\": \"fieldAccess\", \"fieldName\": \"sketch\"}}", "  ],", "  \"intervals\": [\"2016-01-01T00:00:00.000Z/2016-01-31T00:00:00.000Z\"]", "}"));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
    }
}

