/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.sql;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchModule;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimateWithBoundsPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToStringPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchApproxCountDistinctSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchEstimateOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchEstimateWithErrorBoundsOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchObjectSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchSetUnionOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchToStringOperatorConversion;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HllSketchSqlAggregatorTest
extends CalciteTestBase {
    private static final String DATA_SOURCE = "foo";
    private static final boolean ROUND = true;
    private static final Map<String, Object> QUERY_CONTEXT_DEFAULT = ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy");
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private static AuthenticationResult authenticationResult;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create((ObjectMapper)TestHelper.JSON_MAPPER);
    private SpecificSegmentsQuerySegmentWalker walker;
    private SqlLifecycleFactory sqlLifecycleFactory;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        HllSketchModule.registerSerde();
        for (Module mod : new HllSketchModule().getJacksonModules()) {
            CalciteTests.getJsonMapper().registerModule(mod);
            TestHelper.JSON_MAPPER.registerModule(mod);
        }
        QueryableIndex index = IndexBuilder.create().tmpDir(this.temporaryFolder.newFolder()).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HllSketchBuildAggregatorFactory("hllsketch_dim1", "dim1", null, null, true)}).withRollup(false).build()).rows((Iterable)CalciteTests.ROWS1).buildMMappedIndex();
        this.walker = new SpecificSegmentsQuerySegmentWalker(conglomerate).add(DataSegment.builder().dataSource(DATA_SOURCE).interval(index.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index);
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = new DruidOperatorTable((Set)ImmutableSet.of((Object)new HllSketchApproxCountDistinctSqlAggregator(), (Object)new HllSketchObjectSqlAggregator()), (Set)ImmutableSet.of((Object)new HllSketchEstimateOperatorConversion(), (Object)new HllSketchEstimateWithErrorBoundsOperatorConversion(), (Object)new HllSketchSetUnionOperatorConversion(), (Object)new HllSketchToStringOperatorConversion()));
        SchemaPlus rootSchema = CalciteTests.createMockRootSchema((QueryRunnerFactoryConglomerate)conglomerate, (SpecificSegmentsQuerySegmentWalker)this.walker, (PlannerConfig)plannerConfig, (AuthorizerMapper)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        this.sqlLifecycleFactory = CalciteTests.createSqlLifecycleFactory((PlannerFactory)new PlannerFactory(rootSchema, CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, (QueryRunnerFactoryConglomerate)conglomerate), operatorTable, CalciteTests.createExprMacroTable(), plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid"));
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
    }

    @Test
    public void testApproxCountDistinctHllSketch() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT_DS_HLL(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT_DS_HLL(SUBSTRING(dim2, 1, 1) || 'x'),\n  APPROX_COUNT_DISTINCT_DS_HLL(hllsketch_dim1, 21, 'HLL_8'),\n  APPROX_COUNT_DISTINCT_DS_HLL(hllsketch_dim1)\nFROM druid.foo";
        List results = sqlLifecycle.runSimple("SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT_DS_HLL(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT_DS_HLL(SUBSTRING(dim2, 1, 1) || 'x'),\n  APPROX_COUNT_DISTINCT_DS_HLL(hllsketch_dim1, 21, 'HLL_8'),\n  APPROX_COUNT_DISTINCT_DS_HLL(hllsketch_dim1)\nFROM druid.foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 2L, 2L, 1L, 2L, 5L, 5L}) : ImmutableList.of((Object)new Object[]{6L, 2L, 2L, 1L, 1L, 5L, 5L});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Assert.assertEquals((Object)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ValueType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("v1", "concat(substring(\"dim2\", 0, 1),'x')", ValueType.STRING, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("a0", "cnt"), (Object)new HllSketchBuildAggregatorFactory("a1", "dim2", null, null, true), (Object)new FilteredAggregatorFactory((AggregatorFactory)new HllSketchBuildAggregatorFactory("a2", "dim2", null, null, true), (DimFilter)BaseCalciteQueryTest.not((DimFilter)BaseCalciteQueryTest.selector((String)"dim2", (String)"", null))), (Object)new HllSketchBuildAggregatorFactory("a3", "v0", null, null, true), (Object)new HllSketchBuildAggregatorFactory("a4", "v1", null, null, true), (Object)new HllSketchMergeAggregatorFactory("a5", "hllsketch_dim1", Integer.valueOf(21), "HLL_8", true), (Object)new HllSketchMergeAggregatorFactory("a6", "hllsketch_dim1", null, null, true))).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build(), (Object)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries()));
    }

    @Test
    public void testAvgDailyCountDistinctHllSketch() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  AVG(u)\nFROM (  SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT_DS_HLL(cnt) AS u\n  FROM druid.foo\n  GROUP BY 1\n)";
        List results = sqlLifecycle.runSimple("SELECT\n  AVG(u)\nFROM (  SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT_DS_HLL(cnt) AS u\n  FROM druid.foo\n  GROUP BY 1\n)", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{1L});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        GroupByQuery expected = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(Collections.singletonList(new HllSketchBuildAggregatorFactory("a0:a", "cnt", null, null, true))).postAggregators((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).context(BaseCalciteQueryTest.getTimeseriesContextWithFloorTime((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy"), (String)"d0")).build())).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setGranularity(Granularities.ALL).setAggregatorSpecs(NullHandling.replaceWithDefault() ? Arrays.asList(new LongSumAggregatorFactory("_a0:sum", "a0"), new CountAggregatorFactory("_a0:count")) : Arrays.asList(new LongSumAggregatorFactory("_a0:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), (DimFilter)BaseCalciteQueryTest.not((DimFilter)BaseCalciteQueryTest.selector((String)"a0", null, null))))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a0:sum"), (Object)new FieldAccessPostAggregator(null, "_a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build();
        Query actual = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testApproxCountDistinctHllSketchIsRounded() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT   dim2,   APPROX_COUNT_DISTINCT_DS_HLL(m1) FROM druid.foo GROUP BY dim2 HAVING APPROX_COUNT_DISTINCT_DS_HLL(m1) = 2";
        List results = sqlLifecycle.runSimple("SELECT   dim2,   APPROX_COUNT_DISTINCT_DS_HLL(m1) FROM druid.foo GROUP BY dim2 HAVING APPROX_COUNT_DISTINCT_DS_HLL(m1) = 2", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        int expected = NullHandling.replaceWithDefault() ? 1 : 2;
        Assert.assertEquals((long)expected, (long)results.size());
    }

    @Test
    public void testHllSketchPostAggs() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT\n  DS_HLL(dim2),\n  DS_HLL(m1),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2)),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2)) + 1,\n  HLL_SKETCH_ESTIMATE(DS_HLL(CONCAT(dim2, 'hello'))),\n  ABS(HLL_SKETCH_ESTIMATE(DS_HLL(dim2))),\n  HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS(DS_HLL(dim2), 2),\n  HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS(DS_HLL(dim2)),\n  DS_HLL(POWER(ABS(m1 + 100), 2)),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2),\n  HLL_SKETCH_TO_STRING(DS_HLL(dim2)),\n  UPPER(HLL_SKETCH_TO_STRING(DS_HLL(dim2))),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2), true)\nFROM druid.foo";
        List results = sqlLifecycle.runSimple("SELECT\n  DS_HLL(dim2),\n  DS_HLL(m1),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2)),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2)) + 1,\n  HLL_SKETCH_ESTIMATE(DS_HLL(CONCAT(dim2, 'hello'))),\n  ABS(HLL_SKETCH_ESTIMATE(DS_HLL(dim2))),\n  HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS(DS_HLL(dim2), 2),\n  HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS(DS_HLL(dim2)),\n  DS_HLL(POWER(ABS(m1 + 100), 2)),\n  APPROX_COUNT_DISTINCT_DS_HLL(dim2),\n  HLL_SKETCH_TO_STRING(DS_HLL(dim2)),\n  UPPER(HLL_SKETCH_TO_STRING(DS_HLL(dim2))),\n  HLL_SKETCH_ESTIMATE(DS_HLL(dim2), true)\nFROM druid.foo", QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"\"AgEHDAMIAgDhUv8P63iABQ==\"", "\"AgEHDAMIBgALpZ0PjpTfBY5ElQo+C7UE4jA+DKfcYQQ=\"", 2.000000004967054, 3.000000004967054, 3.000000014901161, 2.000000004967054, "[2.000000004967054,2.0,2.0001997319422404]", "[2.000000004967054,2.0,2.000099863468538]", "\"AgEHDAMIBgC1EYgH1mlHBwsKPwu5SK8MIiUxB7iZVwU=\"", 2L, "### HLL SKETCH SUMMARY: \n  Log Config K   : 12\n  Hll Target     : HLL_4\n  Current Mode   : LIST\n  Memory         : false\n  LB             : 2.0\n  Estimate       : 2.000000004967054\n  UB             : 2.000099863468538\n  OutOfOrder Flag: false\n  Coupon Count   : 2\n", "### HLL SKETCH SUMMARY: \n  LOG CONFIG K   : 12\n  HLL TARGET     : HLL_4\n  CURRENT MODE   : LIST\n  MEMORY         : FALSE\n  LB             : 2.0\n  ESTIMATE       : 2.000000004967054\n  UB             : 2.000099863468538\n  OUTOFORDER FLAG: FALSE\n  COUPON COUNT   : 2\n", 2.0});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(\"dim2\",'hello')", ValueType.STRING, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("v1", "pow(abs((\"m1\" + 100)),2)", ValueType.DOUBLE, TestExprMacroTable.INSTANCE)}).aggregators((List)ImmutableList.of((Object)new HllSketchBuildAggregatorFactory("a0", "dim2", null, null, true), (Object)new HllSketchBuildAggregatorFactory("a1", "m1", null, null, true), (Object)new HllSketchBuildAggregatorFactory("a2", "v0", null, null, true), (Object)new HllSketchBuildAggregatorFactory("a3", "v1", null, null, true), (Object)new HllSketchBuildAggregatorFactory("a4", "dim2", null, null, true))).postAggregators((List)ImmutableList.of((Object)new FieldAccessPostAggregator("p0", "a0"), (Object)new FieldAccessPostAggregator("p1", "a1"), (Object)new HllSketchToEstimatePostAggregator("p3", (PostAggregator)new FieldAccessPostAggregator("p2", "a0"), false), (Object)new HllSketchToEstimatePostAggregator("p5", (PostAggregator)new FieldAccessPostAggregator("p4", "a0"), false), (Object)new ExpressionPostAggregator("p6", "(p5 + 1)", null, TestExprMacroTable.INSTANCE), (Object)new HllSketchToEstimatePostAggregator("p8", (PostAggregator)new FieldAccessPostAggregator("p7", "a2"), false), (Object)new HllSketchToEstimatePostAggregator("p10", (PostAggregator)new FieldAccessPostAggregator("p9", "a0"), false), (Object)new ExpressionPostAggregator("p11", "abs(p10)", null, TestExprMacroTable.INSTANCE), (Object)new HllSketchToEstimateWithBoundsPostAggregator("p13", (PostAggregator)new FieldAccessPostAggregator("p12", "a0"), Integer.valueOf(2)), (Object)new HllSketchToEstimateWithBoundsPostAggregator("p15", (PostAggregator)new FieldAccessPostAggregator("p14", "a0"), Integer.valueOf(1)), (Object)new FieldAccessPostAggregator("p16", "a3"), (Object)new HllSketchToStringPostAggregator("p18", (PostAggregator)new FieldAccessPostAggregator("p17", "a0")), (Object[])new PostAggregator[]{new HllSketchToStringPostAggregator("p20", (PostAggregator)new FieldAccessPostAggregator("p19", "a0")), new ExpressionPostAggregator("p21", "upper(p20)", null, TestExprMacroTable.INSTANCE), new HllSketchToEstimatePostAggregator("p23", (PostAggregator)new FieldAccessPostAggregator("p22", "a0"), true)})).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    @Test
    public void testtHllSketchPostAggsPostSort() throws Exception {
        SqlLifecycle sqlLifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "SELECT DS_HLL(dim2) as y FROM druid.foo ORDER BY HLL_SKETCH_ESTIMATE(DS_HLL(dim2)) DESC LIMIT 10";
        String sql2 = StringUtils.format((String)"SELECT HLL_SKETCH_ESTIMATE(y), HLL_SKETCH_TO_STRING(y) from (%s)", (Object[])new Object[]{"SELECT DS_HLL(dim2) as y FROM druid.foo ORDER BY HLL_SKETCH_ESTIMATE(DS_HLL(dim2)) DESC LIMIT 10"});
        List results = sqlLifecycle.runSimple(sql2, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, authenticationResult).toList();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{2.000000004967054, "### HLL SKETCH SUMMARY: \n  Log Config K   : 12\n  Hll Target     : HLL_4\n  Current Mode   : LIST\n  Memory         : false\n  LB             : 2.0\n  Estimate       : 2.000000004967054\n  UB             : 2.000099863468538\n  OutOfOrder Flag: false\n  Coupon Count   : 2\n"});
        Assert.assertEquals((long)expectedResults.size(), (long)results.size());
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedResults.get(i)), (Object[])((Object[])results.get(i)));
        }
        Query actualQuery = (Query)Iterables.getOnlyElement((Iterable)this.queryLogHook.getRecordedQueries());
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource(DATA_SOURCE).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new HllSketchBuildAggregatorFactory("a0", "dim2", null, null, true))).postAggregators((List)ImmutableList.of((Object)new FieldAccessPostAggregator("p0", "a0"), (Object)new HllSketchToEstimatePostAggregator("p2", (PostAggregator)new FieldAccessPostAggregator("p1", "a0"), false), (Object)new HllSketchToEstimatePostAggregator("s1", (PostAggregator)new FieldAccessPostAggregator("s0", "p0"), false), (Object)new HllSketchToStringPostAggregator("s3", (PostAggregator)new FieldAccessPostAggregator("s2", "p0")))).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)true, (Object)"sqlQueryId", (Object)"dummy")).build();
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }

    static {
        authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
    }
}

