/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.core.JsonProcessingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimatePostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class HllSketchToEstimatePostAggregatorTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        HllSketchToEstimatePostAggregator there = new HllSketchToEstimatePostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), true);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        HllSketchToEstimatePostAggregator andBackAgain = (HllSketchToEstimatePostAggregator)mapper.readValue(mapper.writeValueAsString((Object)there), HllSketchToEstimatePostAggregator.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
        Assert.assertArrayEquals((byte[])there.getCacheKey(), (byte[])andBackAgain.getCacheKey());
    }

    @Test
    public void testToString() {
        HllSketchToEstimatePostAggregator postAgg = new HllSketchToEstimatePostAggregator("post", (PostAggregator)new FieldAccessPostAggregator("field1", "sketch"), true);
        Assert.assertEquals((Object)"HllSketchToEstimatePostAggregator{name='post', field=FieldAccessPostAggregator{name='field1', fieldName='sketch'}, round=true}", (Object)postAgg.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(HllSketchToEstimatePostAggregator.class).withNonnullFields(new String[]{"name", "field"}).usingGetClass().verify();
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new HllSketchMergeAggregatorFactory("hllMerge", "col", null, null, false)}).postAggregators(new PostAggregator[]{new HllSketchToEstimatePostAggregator("hllEstimate", (PostAggregator)new FieldAccessPostAggregator(null, "hllMerge"), false), new HllSketchToEstimatePostAggregator("hllEstimateRound", (PostAggregator)new FieldAccessPostAggregator(null, "hllMerge"), true)}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("hllMerge", null).add("hllEstimate", ValueType.DOUBLE).add("hllEstimateRound", ValueType.LONG).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

