/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HllSketchMergeAggregatorFactoryTest {
    private static final String NAME = "name";
    private static final String FIELD_NAME = "fieldName";
    private static final int LG_K = 2;
    private static final String TGT_HLL_TYPE = TgtHllType.HLL_6.name();
    private static final boolean ROUND = true;
    private HllSketchMergeAggregatorFactory targetRound;
    private HllSketchMergeAggregatorFactory targetNoRound;

    @Before
    public void setUp() {
        this.targetRound = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(2), TGT_HLL_TYPE, true);
        this.targetNoRound = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(2), TGT_HLL_TYPE, false);
    }

    @Test(expected=AggregatorFactoryNotMergeableException.class)
    public void testGetMergingFactoryBadName() throws Exception {
        HllSketchMergeAggregatorFactory other = new HllSketchMergeAggregatorFactory("name-diff", FIELD_NAME, Integer.valueOf(2), TGT_HLL_TYPE, true);
        this.targetRound.getMergingFactory((AggregatorFactory)other);
    }

    @Test(expected=AggregatorFactoryNotMergeableException.class)
    public void testGetMergingFactoryBadType() throws Exception {
        HllSketchBuildAggregatorFactory other = new HllSketchBuildAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(2), TGT_HLL_TYPE, true);
        this.targetRound.getMergingFactory((AggregatorFactory)other);
    }

    @Test
    public void testGetMergingFactoryOtherSmallerLgK() throws Exception {
        boolean smallerLgK = true;
        HllSketchMergeAggregatorFactory other = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(1), TGT_HLL_TYPE, true);
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)other);
        Assert.assertEquals((long)2L, (long)result.getLgK());
    }

    @Test
    public void testGetMergingFactoryOtherLargerLgK() throws Exception {
        int largerLgK = 3;
        HllSketchMergeAggregatorFactory other = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(3), TGT_HLL_TYPE, true);
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)other);
        Assert.assertEquals((long)3L, (long)result.getLgK());
    }

    @Test
    public void testGetMergingFactoryOtherSmallerTgtHllType() throws Exception {
        String smallerTgtHllType = TgtHllType.HLL_4.name();
        HllSketchMergeAggregatorFactory other = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(2), smallerTgtHllType, true);
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)other);
        Assert.assertEquals((Object)TGT_HLL_TYPE, (Object)result.getTgtHllType());
    }

    @Test
    public void testGetMergingFactoryOtherLargerTgtHllType() throws Exception {
        String largerTgtHllType = TgtHllType.HLL_8.name();
        HllSketchMergeAggregatorFactory other = new HllSketchMergeAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(2), largerTgtHllType, true);
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)other);
        Assert.assertEquals((Object)largerTgtHllType, (Object)result.getTgtHllType());
    }

    @Test
    public void testGetMergingFactoryThisNoRoundOtherNoRound() throws Exception {
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetNoRound.getMergingFactory((AggregatorFactory)this.targetNoRound);
        Assert.assertFalse((boolean)result.isRound());
    }

    @Test
    public void testGetMergingFactoryThisNoRoundOtherRound() throws Exception {
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetNoRound.getMergingFactory((AggregatorFactory)this.targetRound);
        Assert.assertTrue((boolean)result.isRound());
    }

    @Test
    public void testGetMergingFactoryThisRoundOtherNoRound() throws Exception {
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)this.targetNoRound);
        Assert.assertTrue((boolean)result.isRound());
    }

    @Test
    public void testGetMergingFactoryThisRoundOtherRound() throws Exception {
        HllSketchAggregatorFactory result = (HllSketchAggregatorFactory)this.targetRound.getMergingFactory((AggregatorFactory)this.targetRound);
        Assert.assertTrue((boolean)result.isRound());
    }
}

